/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.stabs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.ISymbolReader;

public class StabsReader
implements ISymbolReader {
    byte[] stabData;
    byte[] stabstrData;
    boolean isLe;
    List fileList;
    String[] files = null;
    boolean parsed = false;
    String currentFile;

    public StabsReader(byte[] data, byte[] stabstr, boolean littleEndian) {
        this.stabData = data;
        this.stabstrData = stabstr;
        this.isLe = littleEndian;
        this.fileList = new ArrayList();
    }

    public String[] getSourceFiles() {
        if (!this.parsed) {
            this.parse();
            this.parsed = true;
            this.files = new String[this.fileList.size()];
            int i = 0;
            while (i < this.fileList.size()) {
                this.files[i] = (String)this.fileList.get(i);
                ++i;
            }
        }
        return this.files;
    }

    private String makeString(long offset) {
        StringBuffer buf = new StringBuffer();
        while (offset < (long)this.stabstrData.length) {
            byte b = this.stabstrData[(int)offset];
            if (b == 0) break;
            buf.append((char)b);
            ++offset;
        }
        return buf.toString();
    }

    private int read_4_bytes(byte[] bytes, int offset) {
        if (this.isLe) {
            return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
        }
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    private short read_2_bytes(byte[] bytes, int offset) {
        if (this.isLe) {
            return (short)((bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF);
        }
        return (short)((bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF);
    }

    private String fixUpPath(String path) {
        StringBuffer buf;
        char driveLetter;
        if ((path = path.replaceAll("\\\\\\\\", "\\\\")).startsWith("/cygdrive/") && '/' == path.charAt(11)) {
            driveLetter = path.charAt(10);
            driveLetter = Character.isLowerCase(driveLetter) ? Character.toUpperCase(driveLetter) : driveLetter;
            buf = new StringBuffer(path);
            buf.delete(0, 11);
            buf.insert(0, driveLetter);
            buf.insert(1, ':');
            path = buf.toString();
        }
        if (path.startsWith("//") && '/' == path.charAt(3)) {
            driveLetter = path.charAt(2);
            driveLetter = Character.isLowerCase(driveLetter) ? Character.toUpperCase(driveLetter) : driveLetter;
            buf = new StringBuffer(path);
            buf.delete(0, 3);
            buf.insert(0, driveLetter);
            buf.insert(1, ':');
            path = buf.toString();
        }
        return path;
    }

    private void parse() {
        long nstab = this.stabData.length / 12;
        String holder = null;
        long stroff = 0L;
        int type = 0;
        int other = 0;
        short desc = 0;
        long value = 0L;
        int offset = 0;
        int i = 0;
        while ((long)i < nstab) {
            type = 0xFF & this.stabData[offset + 4];
            if (type == 100 || type == 132) {
                other = 0xFF & this.stabData[offset + 5];
                desc = this.read_2_bytes(this.stabData, offset + 6);
                value = this.read_4_bytes(this.stabData, offset + 8);
                stroff = this.read_4_bytes(this.stabData, offset);
                String field = stroff > 0L ? this.makeString(stroff) : new String();
                if (field.endsWith("\\") || field.endsWith("?")) {
                    field = field.substring(0, field.length() - 1);
                    holder = holder == null ? field : String.valueOf(holder) + field;
                } else {
                    if (holder != null) {
                        field = String.valueOf(holder) + field;
                        holder = null;
                    }
                    this.parseStabEntry(field, type, other, desc, value);
                }
            }
            ++i;
            offset += 12;
        }
    }

    void parseStabEntry(String field, int type, int other, short desc, long value) {
        switch (type) {
            case 132: {
                if (field == null || field.length() <= 0 || this.fileList.contains(field = this.fixUpPath(field))) break;
                this.fileList.add(field);
                break;
            }
            case 100: {
                if (field == null || field.length() <= 0) break;
                if (field.endsWith("/")) {
                    this.currentFile = field;
                    break;
                }
                this.currentFile = this.currentFile != null ? (new File(field).isAbsolute() ? field : String.valueOf(this.currentFile) + field) : field;
                this.currentFile = this.fixUpPath(this.currentFile);
                if (!this.fileList.contains(this.currentFile)) {
                    this.fileList.add(this.currentFile);
                }
                this.currentFile = null;
            }
        }
    }
}

