/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.eclipse.osgi.internal.verifier.SignedStorageHook;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public class SignedBundleHook
implements AdaptorHook,
BundleFileWrapperFactoryHook,
HookConfigurator,
CertificateVerifierFactory {
    private static BaseAdaptor ADAPTOR;
    private static String SIGNED_BUNDLE_SUPPORT;
    private static boolean supportSignedBundles;
    private ServiceRegistration reg;
    static /* synthetic */ Class class$0;

    static {
        SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
        supportSignedBundles = false;
    }

    public boolean matchDNChain(String pattern, String[] dnChain) {
        boolean satisfied = false;
        if (dnChain != null) {
            int i = 0;
            while (i < dnChain.length) {
                if (DNChainMatching.match(dnChain[i], pattern)) {
                    satisfied = true;
                    break;
                }
                ++i;
            }
        }
        return satisfied;
    }

    public void initialize(BaseAdaptor adaptor) {
        ADAPTOR = adaptor;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.reg = context.registerService(clazz.getName(), (Object)this, null);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) {
        try {
            if (bundleFile != null) {
                SignedStorageHook hook = (SignedStorageHook)data.getStorageHook(SignedStorageHook.KEY);
                SignedBundleFile signedBaseFile = base && hook != null && hook.signedBundleFile != null ? hook.signedBundleFile : new SignedBundleFile();
                signedBaseFile.setBundleFile(bundleFile);
                if (signedBaseFile.isSigned()) {
                    bundleFile = signedBaseFile;
                }
            }
        }
        catch (IOException iOException) {}
        return bundleFile;
    }

    public void addHooks(HookRegistry hookRegistry) {
        supportSignedBundles = "true".equals(FrameworkProperties.getProperty(SIGNED_BUNDLE_SUPPORT));
        hookRegistry.addAdaptorHook(this);
        if (supportSignedBundles) {
            hookRegistry.addStorageHook(new SignedStorageHook());
            hookRegistry.addBundleFileWrapperFactoryHook(this);
        }
    }

    public CertificateVerifier getVerifier(File content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        BundleFile contentBundleFile = content.isDirectory() ? new DirBundleFile(content) : new ZipBundleFile(content, null);
        SignedBundleFile result = new SignedBundleFile();
        result.setBundleFile(contentBundleFile);
        return result;
    }

    public CertificateVerifier getVerifier(Bundle bundle) throws IOException {
        BundleData data = ((AbstractBundle)bundle).getBundleData();
        if (!(data instanceof BaseData)) {
            throw new IllegalArgumentException("Invalid bundle object.  No BaseData found.");
        }
        BundleFile bundleFile = ((BaseData)data).getBundleFile();
        if (bundleFile instanceof SignedBundleFile) {
            return (SignedBundleFile)bundleFile;
        }
        return this.getVerifier(bundleFile.getBaseFile());
    }

    static void log(String msg, int severity, Throwable t) {
        if (ADAPTOR == null) {
            System.err.println(msg);
            t.printStackTrace();
            return;
        }
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", severity, 0, msg, 0, t, null);
        ADAPTOR.getFrameworkLog().log(entry);
    }
}

