/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;

public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String HYPHEN = "-";
    public static final String NUM_PROC = "-p";
    public static final String PROC_PER_NODE = "-N";
    public static final String START_NODE = "-o";
    public static final String PROG_NAME = "--";

    protected IModelManager getLaunchManager() {
        return PTPCorePlugin.getDefault().getModelManager();
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProject getProject(String proName) {
        return this.getWorkspaceRoot().getProject(proName);
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String proName = AbstractParallelLaunchConfigurationDelegate.getProjectName(configuration);
        if (proName == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Project_not_specified"), null, 1);
        }
        if ((project = this.getProject(proName)) == null || !project.exists() || !project.isOpen()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Project_does_not_exist_or_is_not_a_project"), null, 1);
        }
        return project;
    }

    protected IPath getProgramFile(ILaunchConfiguration configuration) throws CoreException {
        Path programPath;
        IProject project = this.verifyProject(configuration);
        String fileName = AbstractParallelLaunchConfigurationDelegate.getProgramName(configuration);
        if (fileName == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_not_specified"), null, 1);
        }
        if (!(programPath = new Path(fileName)).isAbsolute()) {
            programPath = project.getFile((IPath)programPath).getLocation();
        }
        if (!programPath.toFile().exists()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.PROGRAM_PATH_not_found")), 104);
        }
        return programPath;
    }

    protected String[] getProgramParameters(ILaunchConfiguration configuration) throws CoreException {
        String args = AbstractParallelLaunchConfigurationDelegate.getArgument(configuration);
        if (args == null) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(args);
        String[] res = parser.parseArguments();
        return res;
    }

    protected JobRunConfiguration getJobRunConfiguration(ILaunchConfiguration configuration) throws CoreException {
        IPath programFile = this.getProgramFile(configuration);
        String nprocs_str = AbstractParallelLaunchConfigurationDelegate.getNumberOfProcesses(configuration);
        String nprocpnode_str = AbstractParallelLaunchConfigurationDelegate.getNumberOfProcessesPerNode(configuration);
        String firstnode_str = AbstractParallelLaunchConfigurationDelegate.getFirstNodeNumber(configuration);
        String machineName = AbstractParallelLaunchConfigurationDelegate.getMachineName(configuration);
        String[] args = this.getProgramParameters(configuration);
        String[] env = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        String dir = this.verifyWorkDirectory(configuration);
        int nprocs = -1;
        int nprocpnode = -1;
        int firstnode = -1;
        try {
            nprocs = new Integer(nprocs_str);
            nprocpnode = new Integer(nprocpnode_str);
            firstnode = new Integer(firstnode_str);
        }
        catch (NumberFormatException numberFormatException) {}
        return new JobRunConfiguration(programFile.lastSegment(), programFile.removeLastSegments(1).toOSString(), machineName, nprocs, nprocpnode, firstnode, args, env, dir);
    }

    protected String verifyWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workPath = AbstractParallelLaunchConfigurationDelegate.getWorkDirectory(configuration);
        if (workPath == null) {
            IProject project = this.verifyProject(configuration);
            if (project != null) {
                return project.getLocation().toOSString();
            }
        } else {
            Path path = new Path(workPath);
            if (path.isAbsolute()) {
                File dir = new File(path.toOSString());
                if (dir.isDirectory()) {
                    return path.toOSString();
                }
                this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Application_path_not_found", path.toOSString())), 1);
            } else {
                IResource res = this.getWorkspaceRoot().findMember((IPath)path);
                if (res instanceof IContainer && res.exists()) {
                    return res.getLocation().toOSString();
                }
                this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Application_path_not_found", path.toOSString())), 1);
            }
        }
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), code, message, exception));
    }

    protected static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
    }

    protected static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", null);
    }

    protected static String getMachineName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.MACHINE_NAME", null);
    }

    protected static String getNumberOfProcesses(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES", null);
    }

    protected static String getNumberOfProcessesPerNode(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES_START", null);
    }

    protected static String getFirstNodeNumber(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.NODE_NUMBER", null);
    }

    protected static String getArgument(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", null);
    }

    protected static String getWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
    }

    protected static String getDebuggerID(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", null);
    }

    protected static String getDebuggerExePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
    }

    protected static String getDebuggerWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }

    protected IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        IPDebugConfiguration dbgCfg = null;
        try {
            dbgCfg = PTPDebugCorePlugin.getDefault().getDebugConfiguration(AbstractParallelLaunchConfigurationDelegate.getDebuggerID(config));
        }
        catch (CoreException e) {
            System.out.println("ParallelLaunchConfigurationDelegate.getDebugConfig() Error");
            throw e;
        }
        return dbgCfg;
    }

    protected void verifyDebuggerPath(String path) throws CoreException {
        if (!this.verifyPath(path)) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Debugger_path_not_found"), new FileNotFoundException(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Debugger_path_not_found")), 104);
        }
    }

    protected boolean verifyPath(String path) {
        Path programPath = new Path(path);
        return programPath != null && !programPath.isEmpty() && programPath.toFile().exists();
    }

    protected IBinaryParser.IBinaryObject verifyBinary(ILaunchConfiguration configuration) throws CoreException {
        IProject project = this.verifyProject(configuration);
        String fileName = AbstractParallelLaunchConfigurationDelegate.getProgramName(configuration);
        Path programPath = new Path(fileName);
        if (!programPath.isAbsolute()) {
            programPath = project.getFile((IPath)programPath).getLocation();
        }
        return this.verifyBinary(project, (IPath)programPath);
    }

    protected IBinaryParser.IBinaryObject verifyBinary(IProject project, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
            if (exe != null) {
                return exe;
            }
        }
        catch (IOException iOException) {}
        throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 107, LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Program_is_not_a_recongnized_executable"), null));
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                sourceLocator = PTPDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        /*
         * Unable to fully structure code
         */
        public String[] parseArguments() {
            v = new ArrayList<String>();
            this.ch = this.getNext();
            ** GOTO lbl13
            {
                this.ch = this.getNext();
                do {
                    if (Character.isWhitespace((char)this.ch)) continue block0;
                    if (this.ch == 34) {
                        v.add(this.parseString());
                        continue;
                    }
                    v.add(this.parseToken());
lbl13:
                    // 3 sources

                } while (this.ch > 0);
            }
            result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer buf = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

