/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;

public abstract class PLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String DEFAULT_VALUE = "0";
    public static final String EMPTY_STRING = "";

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IContainer getContainer(String workspaceDir) {
        IResource res = this.getResource(workspaceDir);
        if (res instanceof IContainer) {
            return (IContainer)res;
        }
        return null;
    }

    protected IResource getResource(String workspaceDir) {
        return this.getWorkspaceRoot().findMember((IPath)new Path(workspaceDir));
    }

    protected IProject getProject(ILaunchConfiguration configuration) {
        String proName = null;
        try {
            proName = configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (proName == null) {
            return null;
        }
        return this.getWorkspaceRoot().getProject(proName);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected String getPlatform(ILaunchConfiguration config) {
        String platform = Platform.getOS();
        try {
            return config.getAttribute("org.eclipse.ptp.launch.PLATFFORM", platform);
        }
        catch (CoreException coreException) {
            return platform;
        }
    }
}

