/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.ImageUtil;
import com.sun.opengl.util.StreamUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.spi.DDSImage;
import com.sun.opengl.util.texture.spi.SGIImage;
import com.sun.opengl.util.texture.spi.TGAImage;
import com.sun.opengl.util.texture.spi.TextureProvider;
import com.sun.opengl.util.texture.spi.TextureWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class TextureIO {
    public static final String DDS = "dds";
    public static final String SGI = "sgi";
    public static final String SGI_RGB = "rgb";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String TGA = "tga";
    public static final String TIFF = "tiff";
    private static final boolean DEBUG = Debug.debug("TextureIO");
    private static List textureProviders = new ArrayList();
    private static List textureWriters = new ArrayList();

    public static TextureData newTextureData(File file, boolean bl, String string) throws IOException {
        if (string == null) {
            string = FileUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(file, 0, 0, bl, string);
    }

    public static TextureData newTextureData(InputStream inputStream, boolean bl, String string) throws IOException {
        return TextureIO.newTextureDataImpl(inputStream, 0, 0, bl, string);
    }

    public static TextureData newTextureData(URL uRL, boolean bl, String string) throws IOException {
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(uRL, 0, 0, bl, string);
    }

    public static TextureData newTextureData(BufferedImage bufferedImage, boolean bl) {
        return TextureIO.newTextureDataImpl(bufferedImage, 0, 0, bl);
    }

    public static TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = FileUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(file, n, n2, bl, string);
    }

    public static TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(inputStream, n, n2, bl, string);
    }

    public static TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(uRL, n, n2, bl, string);
    }

    public static TextureData newTextureData(BufferedImage bufferedImage, int n, int n2, boolean bl) throws IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(bufferedImage, n, n2, bl);
    }

    public static Texture newTexture(TextureData textureData) throws GLException, IllegalArgumentException {
        if (textureData == null) {
            throw new IllegalArgumentException("Null TextureData");
        }
        return new Texture(textureData);
    }

    public static Texture newTexture(File file, boolean bl) throws IOException, GLException {
        TextureData textureData = TextureIO.newTextureData(file, bl, FileUtil.getFileSuffix(file));
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(InputStream inputStream, boolean bl, String string) throws IOException, GLException {
        TextureData textureData = TextureIO.newTextureData(inputStream, bl, string);
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(URL uRL, boolean bl, String string) throws IOException, GLException {
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        TextureData textureData = TextureIO.newTextureData(uRL, bl, string);
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(BufferedImage bufferedImage, boolean bl) throws GLException {
        TextureData textureData = TextureIO.newTextureData(bufferedImage, bl);
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(int n) throws GLException {
        return new Texture(n);
    }

    public static void write(Texture texture, File file) throws IOException, GLException {
        Object object;
        int n;
        if (texture.getTarget() != 3553) {
            throw new GLException("Only GL_TEXTURE_2D textures are supported");
        }
        GL gL = GLU.getCurrentGL();
        texture.bind();
        int n2 = TextureIO.glGetTexLevelParameteri(3553, 0, 4099);
        int n3 = TextureIO.glGetTexLevelParameteri(3553, 0, 4096);
        int n4 = TextureIO.glGetTexLevelParameteri(3553, 0, 4097);
        int n5 = TextureIO.glGetTexLevelParameteri(3553, 0, 4101);
        TextureData textureData = null;
        if (n2 == 33776 || n2 == 33777 || n2 == 33778 || n2 == 33779) {
            n = TextureIO.glGetTexLevelParameteri(3553, 0, 34464);
            object = ByteBuffer.allocate(n);
            gL.glGetCompressedTexImage(3553, 0, (Buffer)object);
            textureData = new TextureData(n2, n3, n4, n5, n2, 5121, false, true, true, (Buffer)object, null);
        } else {
            n = 0;
            int n6 = 0;
            switch (n2) {
                case 6407: 
                case 32849: 
                case 32992: {
                    n = 3;
                    n6 = 6407;
                    break;
                }
                case 6408: 
                case 32768: 
                case 32856: 
                case 32993: {
                    n = 4;
                    n6 = 6408;
                    break;
                }
                default: {
                    throw new IOException("Unsupported texture internal format 0x" + Integer.toHexString(n2));
                }
            }
            int n7 = TextureIO.glGetInteger(3333);
            int n8 = TextureIO.glGetInteger(3330);
            int n9 = TextureIO.glGetInteger(3331);
            int n10 = TextureIO.glGetInteger(3332);
            int n11 = TextureIO.glGetInteger(3328);
            gL.glPixelStorei(3333, 1);
            gL.glPixelStorei(3330, 0);
            gL.glPixelStorei(3331, 0);
            gL.glPixelStorei(3332, 0);
            gL.glPixelStorei(3328, 0);
            ByteBuffer byteBuffer = ByteBuffer.allocate((n3 + 2 * n5) * (n4 + 2 * n5) * n);
            if (DEBUG) {
                System.err.println("Allocated buffer of size " + byteBuffer.remaining() + " for fetched image (" + (n6 == 6407 ? "GL_RGB" : "GL_RGBA") + ")");
            }
            gL.glGetTexImage(3553, 0, n6, 5121, byteBuffer);
            gL.glPixelStorei(3333, n7);
            gL.glPixelStorei(3330, n8);
            gL.glPixelStorei(3331, n9);
            gL.glPixelStorei(3332, n10);
            gL.glPixelStorei(3328, n11);
            textureData = new TextureData(n2, n3, n4, n5, n6, 5121, false, false, false, byteBuffer, null);
            if (DEBUG) {
                System.out.println("data.getPixelFormat() = " + (textureData.getPixelFormat() == 6407 ? "GL_RGB" : "GL_RGBA"));
            }
        }
        Iterator iterator = textureWriters.iterator();
        while (iterator.hasNext()) {
            object = (TextureWriter)iterator.next();
            if (!object.write(file, textureData)) continue;
            return;
        }
        throw new IOException("No suitable texture writer found");
    }

    public static void addTextureProvider(TextureProvider textureProvider) {
        textureProviders.add(0, textureProvider);
    }

    public static void addTextureWriter(TextureWriter textureWriter) {
        textureWriters.add(0, textureWriter);
    }

    private static TextureData newTextureDataImpl(File file, int n, int n2, boolean bl, String string) throws IOException {
        if (file == null) {
            throw new IOException("File was null");
        }
        string = TextureIO.toLowerCase(string);
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureProvider textureProvider = (TextureProvider)iterator.next();
            TextureData textureData = textureProvider.newTextureData(file, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given file");
    }

    private static TextureData newTextureDataImpl(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
        if (inputStream == null) {
            throw new IOException("Stream was null");
        }
        string = TextureIO.toLowerCase(string);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureProvider textureProvider = (TextureProvider)iterator.next();
            TextureData textureData = textureProvider.newTextureData(inputStream, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given stream");
    }

    private static TextureData newTextureDataImpl(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
        if (uRL == null) {
            throw new IOException("URL was null");
        }
        string = TextureIO.toLowerCase(string);
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureProvider textureProvider = (TextureProvider)iterator.next();
            TextureData textureData = textureProvider.newTextureData(uRL, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given URL");
    }

    private static TextureData newTextureDataImpl(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        return new TextureData(n, n2, bl, bufferedImage);
    }

    private static int glGetInteger(int n) {
        int[] nArray = new int[1];
        GL gL = GLU.getCurrentGL();
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    private static int glGetTexLevelParameteri(int n, int n2, int n3) {
        int[] nArray = new int[1];
        GL gL = GLU.getCurrentGL();
        gL.glGetTexLevelParameteriv(n, 0, n3, nArray, 0);
        return nArray[0];
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    static {
        TextureIO.addTextureProvider(new IIOTextureProvider());
        TextureIO.addTextureProvider(new DDSTextureProvider());
        TextureIO.addTextureProvider(new SGITextureProvider());
        TextureIO.addTextureProvider(new TGATextureProvider());
        textureWriters.add(new IIOTextureWriter());
        TextureIO.addTextureWriter(new DDSTextureWriter());
        TextureIO.addTextureWriter(new SGITextureWriter());
        TextureIO.addTextureWriter(new TGATextureWriter());
    }

    static class DDSTextureProvider
    implements TextureProvider {
        DDSTextureProvider() {
        }

        public TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || TextureIO.DDS.equals(FileUtil.getFileSuffix(file))) {
                DDSImage dDSImage = DDSImage.read(file);
                return this.newTextureData(dDSImage, n, n2, bl);
            }
            return null;
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || DDSImage.isDDSImage(inputStream)) {
                byte[] byArray = StreamUtil.readAll(inputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                DDSImage dDSImage = DDSImage.read(byteBuffer);
                return this.newTextureData(dDSImage, n, n2, bl);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                TextureData textureData = this.newTextureData(bufferedInputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }

        private TextureData newTextureData(DDSImage dDSImage, int n, int n2, boolean bl) {
            TextureData textureData;
            DDSImage.ImageInfo imageInfo = dDSImage.getMipMap(0);
            if (n2 == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            if (imageInfo.isCompressed()) {
                switch (imageInfo.getCompressionFormat()) {
                    case 827611204: {
                        n = 33776;
                        break;
                    }
                    case 861165636: {
                        n = 33778;
                        break;
                    }
                    case 894720068: {
                        n = 33779;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported DDS compression format \"" + DDSImage.getCompressionFormatName(imageInfo.getCompressionFormat()) + "\"");
                    }
                }
            }
            if (n == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            TextureData.Flusher flusher = new TextureData.Flusher(this, dDSImage){
                private final /* synthetic */ DDSImage val$image;
                private final /* synthetic */ DDSTextureProvider this$0;
                {
                    this.this$0 = dDSTextureProvider;
                    this.val$image = dDSImage;
                }

                public void flush() {
                    this.val$image.close();
                }
            };
            if (bl && dDSImage.getNumMipMaps() > 0) {
                Buffer[] bufferArray = new Buffer[dDSImage.getNumMipMaps()];
                for (int i = 0; i < dDSImage.getNumMipMaps(); ++i) {
                    bufferArray[i] = dDSImage.getMipMap(i).getData();
                }
                textureData = new TextureData(n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, imageInfo.isCompressed(), true, bufferArray, flusher);
            } else {
                bl = false;
                textureData = new TextureData(n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, bl, imageInfo.isCompressed(), true, imageInfo.getData(), flusher);
            }
            return textureData;
        }
    }

    static class DDSTextureWriter
    implements TextureWriter {
        DDSTextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.DDS.equals(FileUtil.getFileSuffix(file))) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (n2 != 5120 && n2 != 5121) {
                    throw new IOException("DDS writer only supports byte / unsigned byte textures");
                }
                int n3 = 0;
                switch (n) {
                    case 6407: {
                        n3 = 20;
                        break;
                    }
                    case 6408: {
                        n3 = 21;
                        break;
                    }
                    case 33776: {
                        n3 = 827611204;
                        break;
                    }
                    case 33777: {
                        throw new IOException("RGBA DXT1 not yet supported");
                    }
                    case 33778: {
                        n3 = 861165636;
                        break;
                    }
                    case 33779: {
                        n3 = 894720068;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported pixel format 0x" + Integer.toHexString(n) + " by DDS writer");
                    }
                }
                ByteBuffer[] byteBufferArray = null;
                if (textureData.getMipmapData() != null) {
                    byteBufferArray = new ByteBuffer[textureData.getMipmapData().length];
                    for (int i = 0; i < byteBufferArray.length; ++i) {
                        byteBufferArray[i] = (ByteBuffer)textureData.getMipmapData()[i];
                    }
                } else {
                    byteBufferArray = new ByteBuffer[]{(ByteBuffer)textureData.getBuffer()};
                }
                DDSImage dDSImage = DDSImage.createFromData(n3, textureData.getWidth(), textureData.getHeight(), byteBufferArray);
                dDSImage.write(file);
                return true;
            }
            return false;
        }
    }

    static class IIOTextureProvider
    implements TextureProvider {
        IIOTextureProvider() {
        }

        public TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return null;
            }
            return new TextureData(n, n2, bl, bufferedImage);
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                return null;
            }
            return new TextureData(n, n2, bl, bufferedImage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            InputStream inputStream = uRL.openStream();
            try {
                TextureData textureData = this.newTextureData(inputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                inputStream.close();
            }
        }
    }

    static class IIOTextureWriter
    implements TextureWriter {
        IIOTextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            int n = textureData.getPixelFormat();
            int n2 = textureData.getPixelType();
            if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                byte by;
                int n3;
                BufferedImage bufferedImage = new BufferedImage(textureData.getWidth(), textureData.getHeight(), n == 6407 ? 5 : 6);
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
                if (byteBuffer == null) {
                    byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
                }
                byteBuffer.rewind();
                byteBuffer.get(byArray);
                byteBuffer.rewind();
                if (n == 6407) {
                    for (n3 = 0; n3 < byArray.length; n3 += 3) {
                        byte by2;
                        by = byArray[n3 + 0];
                        byArray[n3 + 0] = by2 = byArray[n3 + 2];
                        byArray[n3 + 2] = by;
                    }
                } else {
                    for (n3 = 0; n3 < byArray.length; n3 += 4) {
                        byte by3;
                        by = byArray[n3 + 0];
                        byte by4 = byArray[n3 + 1];
                        byte by5 = byArray[n3 + 2];
                        byArray[n3 + 0] = by3 = byArray[n3 + 3];
                        byArray[n3 + 1] = by5;
                        byArray[n3 + 2] = by4;
                        byArray[n3 + 3] = by;
                    }
                }
                ImageUtil.flipImageVertically(bufferedImage);
                if (TextureIO.JPG.equals(FileUtil.getFileSuffix(file)) && bufferedImage.getType() == 6) {
                    BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
                    Graphics graphics = bufferedImage2.getGraphics();
                    graphics.drawImage(bufferedImage, 0, 0, null);
                    graphics.dispose();
                    bufferedImage = bufferedImage2;
                }
                return ImageIO.write((RenderedImage)bufferedImage, FileUtil.getFileSuffix(file), file);
            }
            throw new IOException("ImageIO writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
        }
    }

    static class SGITextureProvider
    extends StreamBasedTextureProvider {
        SGITextureProvider() {
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string) || SGIImage.isSGIImage(inputStream)) {
                SGIImage sGIImage = SGIImage.read(inputStream);
                if (n2 == 0) {
                    n2 = sGIImage.getFormat();
                }
                if (n == 0) {
                    n = sGIImage.getFormat();
                }
                return new TextureData(n, sGIImage.getWidth(), sGIImage.getHeight(), 0, n2, 5121, bl, false, false, ByteBuffer.wrap(sGIImage.getData()), null);
            }
            return null;
        }
    }

    static class SGITextureWriter
    implements TextureWriter {
        SGITextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            String string = FileUtil.getFileSuffix(file);
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string)) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                    byte[] byArray;
                    ByteBuffer byteBuffer;
                    ByteBuffer byteBuffer2 = byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byteBuffer.rewind();
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        byteBuffer.rewind();
                    }
                    SGIImage sGIImage = SGIImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408, byArray);
                    sGIImage.write(file, false);
                    return true;
                }
                throw new IOException("SGI writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }

    static abstract class StreamBasedTextureProvider
    implements TextureProvider {
        StreamBasedTextureProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                TextureData textureData = this.newTextureData(bufferedInputStream, n, n2, bl, string != null ? string : FileUtil.getFileSuffix(file));
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                TextureData textureData = this.newTextureData(bufferedInputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }

    static class TGATextureProvider
    extends StreamBasedTextureProvider {
        TGATextureProvider() {
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.TGA.equals(string)) {
                TGAImage tGAImage = TGAImage.read(inputStream);
                if (n2 == 0) {
                    n2 = tGAImage.getGLFormat();
                }
                if (n == 0) {
                    n = 32856;
                }
                return new TextureData(n, tGAImage.getWidth(), tGAImage.getHeight(), 0, n2, 5121, bl, false, false, tGAImage.getData(), null);
            }
            return null;
        }
    }

    static class TGATextureWriter
    implements TextureWriter {
        TGATextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.TGA.equals(FileUtil.getFileSuffix(file))) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                    ByteBuffer byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    int n3 = n == 6407 ? 3 : 4;
                    for (int i = 0; i < byteBuffer.remaining(); i += n3) {
                        byte by = byteBuffer.get(i + 0);
                        byte by2 = byteBuffer.get(i + 2);
                        byteBuffer.put(i + 0, by2);
                        byteBuffer.put(i + 2, by);
                    }
                    TGAImage tGAImage = TGAImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408, false, textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0]);
                    tGAImage.write(file);
                    return true;
                }
                throw new IOException("TGA writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }
}

