/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoringProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.refactoring.ComboSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.PullPushCheckboxTableViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public final class PushDownWizard
extends RefactoringWizard {
    public PushDownWizard(PushDownRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.PushDownWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new PushDownInputPage());
    }

    private static class PushDownInputPage
    extends UserInputWizardPage {
        private static final int ACTION_COLUMN = 1;
        private static final String ACTION_PROPERTY = "action";
        private static final int MEMBER_COLUMN = 0;
        private static final String MEMBER_PROPERTY = "member";
        private static final String PAGE_NAME = "PushDownInputPage";
        private static final int ROW_COUNT = 10;
        private Button fDeselectAllButton;
        private Button fEditButton;
        private Button fSelectAllButton;
        private Label fStatusLine;
        private PullPushCheckboxTableViewer fTableViewer;

        private static int countEditableInfos(PushDownRefactoringProcessor.MemberActionInfo[] infos) {
            int result = 0;
            int index = 0;
            while (index < infos.length) {
                if (infos[index].isEditable()) {
                    ++result;
                }
                ++index;
            }
            return result;
        }

        private static void setInfoAction(PushDownRefactoringProcessor.MemberActionInfo[] infos, int action) {
            int index = 0;
            while (index < infos.length) {
                infos[index].setAction(action);
                ++index;
            }
        }

        public PushDownInputPage() {
            super(PAGE_NAME);
        }

        private boolean areAllElementsMarkedAsNoAction() {
            return this.countInfosForAction(2) == ((PushDownRefactoringProcessor.MemberActionInfo[])this.fTableViewer.getInput()).length;
        }

        private boolean areAllElementsMarkedAsPushDownAction() {
            return this.countInfosForAction(0) == ((PushDownRefactoringProcessor.MemberActionInfo[])this.fTableViewer.getInput()).length;
        }

        private void checkPageCompletionStatus(boolean displayErrorMessage) {
            if (this.areAllElementsMarkedAsNoAction()) {
                if (displayErrorMessage) {
                    this.setErrorMessage(RefactoringMessages.PushDownInputPage_Select_members_to_push_down);
                }
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }

        private int countInfosForAction(int action) {
            PushDownRefactoringProcessor.MemberActionInfo[] infos = (PushDownRefactoringProcessor.MemberActionInfo[])this.fTableViewer.getInput();
            int count = 0;
            int index = 0;
            while (index < infos.length) {
                PushDownRefactoringProcessor.MemberActionInfo info = infos[index];
                if (info.getAction() == action) {
                    ++count;
                }
                ++index;
            }
            return count;
        }

        private void createButtonComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1040));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.fSelectAllButton = new Button(composite, 8);
            this.fSelectAllButton.setText(RefactoringMessages.PullUpWizard_select_all_label);
            this.fSelectAllButton.setLayoutData((Object)new GridData(768));
            this.fSelectAllButton.setEnabled(true);
            SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
            this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void widgetSelected(SelectionEvent event) {
                    IMember[] members = PushDownInputPage.access$1(this.this$1);
                    PushDownInputPage.access$2(this.this$1, members, 0);
                    PushDownInputPage.access$0(this.this$1, null, true);
                }
            });
            this.fDeselectAllButton = new Button(composite, 8);
            this.fDeselectAllButton.setText(RefactoringMessages.PullUpWizard_deselect_all_label);
            this.fDeselectAllButton.setLayoutData((Object)new GridData(768));
            this.fDeselectAllButton.setEnabled(false);
            SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
            this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void widgetSelected(SelectionEvent event) {
                    IMember[] members = PushDownInputPage.access$1(this.this$1);
                    PushDownInputPage.access$2(this.this$1, members, 2);
                    PushDownInputPage.access$0(this.this$1, null, true);
                }
            });
            this.fEditButton = new Button(composite, 8);
            this.fEditButton.setText(RefactoringMessages.PushDownInputPage_Edit);
            GridData data = new GridData(768);
            data.verticalIndent = new PixelConverter((Control)parent).convertVerticalDLUsToPixels(7);
            this.fEditButton.setLayoutData((Object)data);
            this.fEditButton.setEnabled(false);
            SWTUtil.setButtonDimensionHint(this.fEditButton);
            this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void widgetSelected(SelectionEvent event) {
                    PushDownInputPage.access$3(this.this$1);
                }
            });
            Button addButton = new Button(composite, 8);
            addButton.setText(RefactoringMessages.PushDownInputPage_Add_Required);
            addButton.setLayoutData((Object)new GridData(768));
            SWTUtil.setButtonDimensionHint(addButton);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void widgetSelected(SelectionEvent event) {
                    this.this$1.markAdditionalRequiredMembersAsMembersToPushDown();
                }
            });
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createMemberTableLabel(composite);
            this.createMemberTableComposite(composite);
            this.createStatusLine(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.push_down_wizard_page_context");
        }

        private void createMemberTable(Composite parent) {
            TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            Table table = new Table((Composite)layouter, 68386);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            GridData data = new GridData(1808);
            data.heightHint = SWTUtil.getTableHeightHint(table, 10);
            data.widthHint = this.convertWidthInCharsToPixels(30);
            layouter.setLayoutData(data);
            TableLayout layout = new TableLayout();
            table.setLayout((Layout)layout);
            TableColumn first = new TableColumn(table, 0);
            first.setText(RefactoringMessages.PushDownInputPage_Member);
            TableColumn second = new TableColumn(table, 0);
            second.setText(RefactoringMessages.PushDownInputPage_Action);
            this.fTableViewer = new PullPushCheckboxTableViewer(table);
            this.fTableViewer.setUseHashlookup(true);
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemberActionInfoLabelProvider());
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    PushDownInputPage.access$4(this.this$1, (IStructuredSelection)event.getSelection());
                }
            });
            this.fTableViewer.addCheckStateListener(new ICheckStateListener(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean checked = event.getChecked();
                    PushDownRefactoringProcessor.MemberActionInfo info = (PushDownRefactoringProcessor.MemberActionInfo)event.getElement();
                    if (checked) {
                        info.setAction(0);
                    } else {
                        info.setAction(2);
                    }
                    PushDownInputPage.access$0(this.this$1, null, true);
                }
            });
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ PushDownInputPage this$1;
                {
                    this.this$1 = pushDownInputPage;
                }

                public void doubleClick(DoubleClickEvent event) {
                    PushDownInputPage.access$3(this.this$1);
                }
            });
            this.fTableViewer.setInput(this.getPushDownRefactoring().getPushDownProcessor().getMemberActionInfos());
            this.updateWizardPage(null, false);
            this.setupCellEditors(table);
        }

        private void createMemberTableComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.createMemberTable(composite);
            this.createButtonComposite(composite);
        }

        private void createMemberTableLabel(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(RefactoringMessages.PushDownInputPage_Specify_actions);
            label.setLayoutData((Object)new GridData());
        }

        private void createStatusLine(Composite composite) {
            this.fStatusLine = new Label(composite, 0);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            this.updateStatusLine();
            this.fStatusLine.setLayoutData((Object)data);
        }

        private Map createStringMappingForSelectedElements() {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            int action = 0;
            result.put(MemberActionInfoLabelProvider.getActionLabel(action), new Integer(action));
            int action1 = 1;
            result.put(MemberActionInfoLabelProvider.getActionLabel(action1), new Integer(action1));
            return result;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void editSelectedMembers() {
            if (!this.fEditButton.isEnabled()) {
                return;
            }
            ISelection preserved = this.fTableViewer.getSelection();
            try {
                Map stringMapping = this.createStringMappingForSelectedElements();
                Object[] keys = stringMapping.keySet().toArray(new String[stringMapping.keySet().size()]);
                Arrays.sort(keys);
                int initialSelectionIndex = this.getInitialSelectionIndexForEditDialog(stringMapping, (String[])keys);
                ComboSelectionDialog dialog = new ComboSelectionDialog(this.getShell(), RefactoringMessages.PushDownInputPage_Edit_members, RefactoringMessages.PushDownInputPage_Mark_selected_members, (String[])keys, initialSelectionIndex);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    Object var7_6 = null;
                    this.updateWizardPage(preserved, true);
                    return;
                }
                int action = (Integer)stringMapping.get(dialog.getSelectedString());
                PushDownInputPage.setInfoAction(this.getSelectedMemberActionInfos(), action);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.updateWizardPage(preserved, true);
                throw throwable;
            }
            {
                Object var7_8 = null;
                this.updateWizardPage(preserved, true);
                return;
            }
        }

        private boolean enableEditButton(IStructuredSelection selection) {
            if (selection.isEmpty() || selection.size() == 0) {
                return false;
            }
            return selection.size() == PushDownInputPage.countEditableInfos(this.getSelectedMemberActionInfos());
        }

        private PushDownRefactoringProcessor.MemberActionInfo[] getActiveInfos() {
            PushDownRefactoringProcessor.MemberActionInfo[] infos = this.getPushDownRefactoring().getPushDownProcessor().getMemberActionInfos();
            ArrayList<PushDownRefactoringProcessor.MemberActionInfo> result = new ArrayList<PushDownRefactoringProcessor.MemberActionInfo>(infos.length);
            int index = 0;
            while (index < infos.length) {
                PushDownRefactoringProcessor.MemberActionInfo info = infos[index];
                if (info.isActive()) {
                    result.add(info);
                }
                ++index;
            }
            return result.toArray(new PushDownRefactoringProcessor.MemberActionInfo[result.size()]);
        }

        private int getCommonActionCodeForSelectedInfos() {
            PushDownRefactoringProcessor.MemberActionInfo[] infos = this.getSelectedMemberActionInfos();
            if (infos.length == 0) {
                return -1;
            }
            int code = infos[0].getAction();
            int index = 0;
            while (index < infos.length) {
                if (code != infos[index].getAction()) {
                    return -1;
                }
                ++index;
            }
            return code;
        }

        private int getInitialSelectionIndexForEditDialog(Map mapping, String[] keys) {
            int commonActionCode = this.getCommonActionCodeForSelectedInfos();
            if (commonActionCode == -1) {
                return 0;
            }
            Iterator iterator = mapping.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                int action = (Integer)mapping.get(key);
                if (commonActionCode != action) continue;
                int index = 0;
                while (index < keys.length) {
                    if (key.equals(keys[index])) {
                        return index;
                    }
                    ++index;
                }
                Assert.isTrue((boolean)false);
            }
            return 0;
        }

        private IMember[] getMembers() {
            PushDownRefactoringProcessor.MemberActionInfo[] infos = (PushDownRefactoringProcessor.MemberActionInfo[])this.fTableViewer.getInput();
            ArrayList<IMember> result = new ArrayList<IMember>(infos.length);
            int index = 0;
            while (index < infos.length) {
                result.add(infos[index].getMember());
                ++index;
            }
            return result.toArray(new IMember[result.size()]);
        }

        private PushDownRefactoring getPushDownRefactoring() {
            return (PushDownRefactoring)this.getRefactoring();
        }

        private PushDownRefactoringProcessor.MemberActionInfo[] getSelectedMemberActionInfos() {
            Assert.isTrue((boolean)(this.fTableViewer.getSelection() instanceof IStructuredSelection));
            List result = ((IStructuredSelection)this.fTableViewer.getSelection()).toList();
            return result.toArray(new PushDownRefactoringProcessor.MemberActionInfo[result.size()]);
        }

        public void markAdditionalRequiredMembersAsMembersToPushDown() {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(this){
                    final /* synthetic */ PushDownInputPage this$1;
                    {
                        this.this$1 = pushDownInputPage;
                    }

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            try {
                                PushDownInputPage.access$5(this.this$1).getPushDownProcessor().computeAdditionalRequiredMembersToPushDown(pm);
                                PushDownInputPage.access$0(this.this$1, null, true);
                            }
                            catch (JavaModelException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            pm.done();
                            throw throwable;
                        }
                        {
                            Object var3_5 = null;
                        }
                        pm.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.PushDownInputPage_Push_Down, RefactoringMessages.PushDownInputPage_Internal_Error);
            }
            catch (InterruptedException interruptedException) {
                Assert.isTrue((boolean)false);
            }
        }

        private void setActionForMembers(IMember[] members, int action) {
            PushDownRefactoringProcessor.MemberActionInfo[] infos = (PushDownRefactoringProcessor.MemberActionInfo[])this.fTableViewer.getInput();
            int offset = 0;
            while (offset < members.length) {
                int index = 0;
                while (index < infos.length) {
                    if (infos[index].getMember().equals(members[offset])) {
                        infos[index].setAction(action);
                    }
                    ++index;
                }
                ++offset;
            }
        }

        private void setupCellEditors(Table table) {
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor();
            comboBoxCellEditor.setStyle(8);
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = comboBoxCellEditor;
            this.fTableViewer.setCellEditors(cellEditorArray);
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this, comboBoxCellEditor, table){
                final /* synthetic */ PushDownInputPage this$1;
                private final /* synthetic */ ComboBoxCellEditor val$comboBoxCellEditor;
                private final /* synthetic */ Table val$table;
                {
                    this.this$1 = pushDownInputPage;
                    this.val$comboBoxCellEditor = comboBoxCellEditor;
                    this.val$table = table;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    if (this.val$comboBoxCellEditor.getControl() == null & !this.val$table.isDisposed()) {
                        this.val$comboBoxCellEditor.create((Composite)this.val$table);
                    }
                    Assert.isTrue((boolean)(event.getSelection() instanceof IStructuredSelection));
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    if (ss.size() != 1) {
                        return;
                    }
                    PushDownRefactoringProcessor.MemberActionInfo mac = (PushDownRefactoringProcessor.MemberActionInfo)ss.getFirstElement();
                    this.val$comboBoxCellEditor.setItems(MemberActionInfoLabelProvider.access$2(mac));
                    this.val$comboBoxCellEditor.setValue((Object)new Integer(mac.getAction()));
                }
            });
            PushDownCellModifier cellModifier = new PushDownCellModifier();
            this.fTableViewer.setCellModifier(cellModifier);
            this.fTableViewer.setColumnProperties(new String[]{MEMBER_PROPERTY, ACTION_PROPERTY});
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
                this.fTableViewer.getControl().setFocus();
            }
        }

        private void updateButtonEnablementState(IStructuredSelection tableSelection) {
            if (tableSelection == null || this.fEditButton == null) {
                return;
            }
            this.fEditButton.setEnabled(this.enableEditButton(tableSelection));
            if (this.fSelectAllButton != null) {
                this.fSelectAllButton.setEnabled(!this.areAllElementsMarkedAsPushDownAction());
            }
            if (this.fDeselectAllButton != null) {
                this.fDeselectAllButton.setEnabled(!this.areAllElementsMarkedAsNoAction());
            }
        }

        private void updateStatusLine() {
            if (this.fStatusLine == null) {
                return;
            }
            int selected = this.fTableViewer.getCheckedElements().length;
            Object[] keys = new String[]{String.valueOf(selected)};
            String msg = Messages.format(RefactoringMessages.PushDownInputPage_status_line, keys);
            this.fStatusLine.setText(msg);
        }

        private void updateWizardPage(ISelection preserved, boolean displayErrorMessage) {
            this.fTableViewer.refresh();
            if (preserved != null) {
                this.fTableViewer.getControl().setFocus();
                this.fTableViewer.setSelection(preserved);
            }
            this.checkPageCompletionStatus(displayErrorMessage);
            this.updateButtonEnablementState((IStructuredSelection)this.fTableViewer.getSelection());
            this.updateStatusLine();
        }

        static /* synthetic */ IMember[] access$1(PushDownInputPage pushDownInputPage) {
            return pushDownInputPage.getMembers();
        }

        static /* synthetic */ void access$2(PushDownInputPage pushDownInputPage, IMember[] iMemberArray, int n) {
            pushDownInputPage.setActionForMembers(iMemberArray, n);
        }

        static /* synthetic */ void access$3(PushDownInputPage pushDownInputPage) {
            pushDownInputPage.editSelectedMembers();
        }

        static /* synthetic */ void access$4(PushDownInputPage pushDownInputPage, IStructuredSelection iStructuredSelection) {
            pushDownInputPage.updateButtonEnablementState(iStructuredSelection);
        }

        static /* synthetic */ PushDownRefactoring access$5(PushDownInputPage pushDownInputPage) {
            return pushDownInputPage.getPushDownRefactoring();
        }

        private static class MemberActionInfoLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private final ILabelProvider fLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

            private MemberActionInfoLabelProvider() {
            }

            private static String getActionLabel(int action) {
                switch (action) {
                    case 2: {
                        return "";
                    }
                    case 1: {
                        return RefactoringMessages.PushDownInputPage_leave_abstract;
                    }
                    case 0: {
                        return RefactoringMessages.PushDownInputPage_push_down;
                    }
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            private static String[] getAvailableActionLabels(PushDownRefactoringProcessor.MemberActionInfo info) {
                int[] actions = info.getAvailableActions();
                String[] result = new String[actions.length];
                int index = 0;
                while (index < actions.length) {
                    result[index] = MemberActionInfoLabelProvider.getActionLabel(actions[index]);
                    ++index;
                }
                return result;
            }

            public void dispose() {
                this.fLabelProvider.dispose();
                super.dispose();
            }

            public Image getColumnImage(Object element, int index) {
                PushDownRefactoringProcessor.MemberActionInfo info = (PushDownRefactoringProcessor.MemberActionInfo)element;
                switch (index) {
                    case 0: {
                        return this.fLabelProvider.getImage((Object)info.getMember());
                    }
                    case 1: {
                        return null;
                    }
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            public String getColumnText(Object element, int index) {
                PushDownRefactoringProcessor.MemberActionInfo info = (PushDownRefactoringProcessor.MemberActionInfo)element;
                switch (index) {
                    case 0: {
                        return this.fLabelProvider.getText((Object)info.getMember());
                    }
                    case 1: {
                        return MemberActionInfoLabelProvider.getActionLabel(info.getAction());
                    }
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            static /* synthetic */ String[] access$2(PushDownRefactoringProcessor.MemberActionInfo memberActionInfo) {
                return MemberActionInfoLabelProvider.getAvailableActionLabels(memberActionInfo);
            }
        }

        private class PushDownCellModifier
        implements ICellModifier {
            private PushDownCellModifier() {
            }

            public boolean canModify(Object element, String property) {
                if (!PushDownInputPage.ACTION_PROPERTY.equals(property)) {
                    return false;
                }
                return ((PushDownRefactoringProcessor.MemberActionInfo)element).isEditable();
            }

            public Object getValue(Object element, String property) {
                if (!PushDownInputPage.ACTION_PROPERTY.equals(property)) {
                    return null;
                }
                PushDownRefactoringProcessor.MemberActionInfo info = (PushDownRefactoringProcessor.MemberActionInfo)element;
                return new Integer(info.getAction());
            }

            public void modify(Object element, String property, Object value) {
                if (!PushDownInputPage.ACTION_PROPERTY.equals(property)) {
                    return;
                }
                int action = (Integer)value;
                PushDownRefactoringProcessor.MemberActionInfo info = element instanceof Item ? (PushDownRefactoringProcessor.MemberActionInfo)((Item)element).getData() : (PushDownRefactoringProcessor.MemberActionInfo)element;
                if (!this.canModify(info, property)) {
                    return;
                }
                info.setAction(action);
                PushDownInputPage.this.updateWizardPage(null, true);
            }
        }
    }
}

