/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDefaultPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerSelectionPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathFilterPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.IContainerDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ProjectContainerDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ProjectContainerPage;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.ui.wizards.IPathEntryContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CPathContainerWizard
extends Wizard {
    private IContainerDescriptor fPageDesc;
    private IContainerEntry fEntryToEdit;
    private IPathEntry[] fNewEntries;
    private IContainerEntry[] fContainerEntries;
    private IProjectEntry fProjectEntry;
    private IPathEntryContainerPage fContainerPage;
    private ICElement fCurrElement;
    private IPathEntry[] fCurrCPath;
    private CPathFilterPage fFilterPage;
    private CPathContainerSelectionPage fSelectionWizardPage;
    private int[] fFilterType;

    public CPathContainerWizard(IContainerEntry entryToEdit, ICElement currElement, IPathEntry[] currEntries) {
        this(entryToEdit, null, currElement, currEntries, null);
    }

    public CPathContainerWizard(IContainerDescriptor pageDesc, ICElement currElement, IPathEntry[] currEntries) {
        this(null, pageDesc, currElement, currEntries, null);
    }

    public CPathContainerWizard(IContainerEntry entryToEdit, IContainerDescriptor pageDesc, ICElement currElement, IPathEntry[] currEntries, int[] filterType) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntries = null;
        this.fFilterType = filterType;
        this.fCurrElement = currElement;
        this.fCurrCPath = currEntries;
    }

    public IPathEntry getEntriesParent() {
        if (this.fProjectEntry != null) {
            return this.fProjectEntry;
        }
        return this.fContainerEntries[0];
    }

    public IPathEntry[] getEntries() {
        return this.fNewEntries;
    }

    public IContainerEntry[] getContainers() {
        return this.fContainerEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fContainerPage instanceof ProjectContainerPage) {
                this.fProjectEntry = ((ProjectContainerPage)this.fContainerPage).getProjectEntry();
            } else {
                this.fContainerEntries = this.fContainerPage.getNewContainers();
            }
            if (this.fFilterPage != null && this.fFilterPage.isPageComplete()) {
                this.fNewEntries = this.fFilterPage.getSelectedEntries();
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            IContainerDescriptor[] containers = CPathContainerDescriptor.getDescriptors();
            ArrayList<IContainerDescriptor> allContainers = new ArrayList<IContainerDescriptor>(Arrays.asList(containers));
            if (this.fFilterType != null) {
                allContainers.add(0, new ProjectContainerDescriptor(this.fFilterType));
            }
            this.fSelectionWizardPage = new CPathContainerSelectionPage(allContainers.toArray(new IContainerDescriptor[0]));
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new CPathContainerDefaultPage();
            this.addPage(this.fContainerPage);
            if (this.fFilterType != null) {
                this.fFilterPage = new CPathFilterPage(this.fCurrElement, this.fFilterType);
                this.addPage((IWizardPage)this.fFilterPage);
            }
        } else {
            IContainerDescriptor[] containers = CPathContainerDescriptor.getDescriptors();
            IContainerDescriptor descriptor = this.findDescriptorPage(containers, (IPathEntry)this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(descriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IPathEntryContainerPage getContainerPage(IContainerDescriptor pageDesc) {
        IPathEntryContainerPage containerPage = null;
        if (pageDesc != null) {
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new CPathContainerDefaultPage();
        }
        containerPage.initialize(this.fCurrElement.getCProject(), this.fCurrCPath);
        if (!(containerPage instanceof ProjectContainerPage)) {
            containerPage.setSelection(this.fEntryToEdit);
        }
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            IContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        if (page == this.fContainerPage && this.fFilterPage != null) {
            if (this.fContainerPage.finish() && this.fContainerPage.getNewContainers().length > 0 && this.fContainerPage.getNewContainers()[0] != null) {
                Object entry = this.fContainerPage instanceof ProjectContainerPage ? ((ProjectContainerPage)this.fContainerPage).getProjectEntry() : this.fContainerPage.getNewContainers()[0];
                this.fFilterPage.setParentEntry((IPathEntry)entry);
            }
            return this.fFilterPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = CPathEntryMessages.getString("CPathContainerWizard.pagecreationerror.title");
        String message = CPathEntryMessages.getString("CPathContainerWizard.pagecreationerror.message");
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private IContainerDescriptor findDescriptorPage(IContainerDescriptor[] containers, IPathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        boolean canFinish = false;
        if (this.fContainerPage != null) {
            canFinish = this.fContainerPage.isPageComplete();
        }
        if (canFinish && this.fFilterPage != null) {
            canFinish = this.fFilterPage.isPageComplete();
        }
        return canFinish;
    }

    public static int openWizard(Shell shell, CPathContainerWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        return dialog.open();
    }
}

