/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.AbstractPathOptionBlock;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathLibraryEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathOutputEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathProjectsEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathSourceEntryPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CPathTabBlock
extends AbstractPathOptionBlock {
    private final int[] pathTypes = new int[]{8, 4, 128, 1, 32};
    private ListDialogField fCPathList;
    private CPathSourceEntryPage fSourcePage;
    private CPathProjectsEntryPage fProjectsPage;
    private CPathOutputEntryPage fOutputPage;
    private CPathContainerEntryPage fContainerPage;
    private CPathLibraryEntryPage fLibrariesPage;

    void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fCPathList) {
            this.updateCPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public CPathTabBlock(IStatusChangeListener context, int pageToShow) {
        super(context, pageToShow);
        String[] stringArray = new String[5];
        stringArray[0] = CPathEntryMessages.getString("CPathsBlock.path.up.button");
        stringArray[1] = CPathEntryMessages.getString("CPathsBlock.path.down.button");
        stringArray[3] = CPathEntryMessages.getString("CPathsBlock.path.checkall.button");
        stringArray[4] = CPathEntryMessages.getString("CPathsBlock.path.uncheckall.button");
        String[] buttonLabels = stringArray;
        BuildPathAdapter adapter = new BuildPathAdapter();
        this.fCPathList = new ListDialogField(null, buttonLabels, null);
        this.fCPathList.setDialogFieldListener(adapter);
    }

    protected List getCPaths() {
        return this.fCPathList.getElements();
    }

    protected void addTabs() {
        this.fSourcePage = new CPathSourceEntryPage(this.fCPathList);
        this.addPage(this.fSourcePage);
        this.fOutputPage = new CPathOutputEntryPage(this.fCPathList);
        this.addPage(this.fOutputPage);
        this.fProjectsPage = new CPathProjectsEntryPage(this.fCPathList);
        this.addPage(this.fProjectsPage);
        this.fLibrariesPage = new CPathLibraryEntryPage(this.fCPathList);
        this.addPage(this.fLibrariesPage);
        this.fContainerPage = new CPathContainerEntryPage(this.fCPathList);
        this.addPage(this.fContainerPage);
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.getCProject() != null) {
            this.fSourcePage.init(this.getCProject());
            this.fOutputPage.init(this.getCProject());
            this.fProjectsPage.init(this.getCProject());
            this.fContainerPage.init(this.getCProject());
            this.fLibrariesPage.init(this.getCProject());
        }
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    protected void initialize(ICElement element, List cPaths) {
        this.fCPathList.setElements(cPaths);
        if (this.fProjectsPage != null) {
            this.fSourcePage.init(this.getCProject());
            this.fOutputPage.init(this.getCProject());
            this.fProjectsPage.init(this.getCProject());
            this.fContainerPage.init(this.getCProject());
            this.fLibrariesPage.init(this.getCProject());
        }
        this.doStatusLineUpdate();
        this.initializeTimeStamps();
    }

    protected int[] getFilteredTypes() {
        return this.pathTypes;
    }

    protected int[] getAppliedFilteredTypes() {
        return this.pathTypes;
    }

    public void updateCPathStatus() {
        this.getPathStatus().setOK();
        List elements = this.fCPathList.getElements();
        CPElement entryError = null;
        int nErrorEntries = 0;
        IPathEntry[] entries = new IPathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPElement currElement = (CPElement)elements.get(i);
            entries[i] = currElement.getPathEntry();
            if (currElement.getStatus().getSeverity() != 0) {
                ++nErrorEntries;
                if (entryError == null) {
                    entryError = currElement;
                }
            }
            --i;
        }
        if (nErrorEntries > 0) {
            if (nErrorEntries == 1) {
                this.getPathStatus().setWarning(entryError.getStatus().getMessage());
            } else {
                this.getPathStatus().setWarning(CPathEntryMessages.getFormattedString("CPElement.status.multiplePathErrors", String.valueOf(nErrorEntries)));
            }
        }
        this.updateBuildPathStatus();
    }

    private class BuildPathAdapter
    implements IDialogFieldListener {
        private BuildPathAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            CPathTabBlock.this.buildPathDialogFieldChanged(field);
        }
    }
}

