/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;

public class OpenDeclarationsAction
extends SelectionParseAction {
    public static final IASTName[] BLANK_NAME_ARRAY = new IASTName[0];
    ITextSelection selNode;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
    }

    public void run() {
        this.selNode = this.getSelectedStringFromEditor();
        if (this.selNode != null) {
            new Runner().schedule();
        }
    }

    private class Runner
    extends Job {
        Runner() {
            super(CEditorMessages.getString("OpenDeclarations.dialog.title"));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                int selectionStart = OpenDeclarationsAction.this.selNode.getOffset();
                int selectionLength = OpenDeclarationsAction.this.selNode.getLength();
                IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(OpenDeclarationsAction.this.fEditor.getEditorInput());
                if (workingCopy == null) {
                    return Status.CANCEL_STATUS;
                }
                IPDOM pdom = CCorePlugin.getPDOMManager().getPDOM(workingCopy.getCProject());
                pdom.acquireReadLock();
                try {
                    IASTTranslationUnit ast = workingCopy.getLanguage().getASTTranslationUnit((ITranslationUnit)workingCopy, 1);
                    IASTName[] selectedNames = workingCopy.getLanguage().getSelectedNames(ast, selectionStart, selectionLength);
                    if (selectedNames.length > 0 && selectedNames[0] != null) {
                        IASTFileLocation fileloc;
                        IASTName searchName = selectedNames[0];
                        IBinding binding = searchName.resolveBinding();
                        IASTName[] declNames = null;
                        if (binding != null && !(binding instanceof ProblemBinding)) {
                            boolean isDefinition = searchName.isDefinition();
                            IASTName[] iASTNameArray = declNames = isDefinition ? ast.getDeclarations(binding) : ast.getDefinitions(binding);
                            if (declNames.length == 0) {
                                IASTName[] iASTNameArray2 = declNames = isDefinition ? ast.getDefinitions(binding) : ast.getDeclarations(binding);
                            }
                        }
                        if (declNames == null || declNames.length == 0) {
                            IBinding[] bindings = pdom.findBindings(GPPLanguage.createSearchPattern((IASTName)searchName), monitor);
                            int i = 0;
                            while (i < bindings.length && (declNames = ((PDOM)pdom).getDefinitions(bindings[i])).length <= 0) {
                                ++i;
                            }
                            if (declNames == null || declNames.length == 0) {
                                i = 0;
                                while (i < bindings.length && (declNames = ((PDOM)pdom).getDeclarations(bindings[i])).length <= 0) {
                                    ++i;
                                }
                            }
                        }
                        if (declNames != null && declNames.length > 0 && (fileloc = declNames[0].getFileLocation()) != null) {
                            Path path = new Path(fileloc.getFileName());
                            int offset = fileloc.getNodeOffset();
                            int length = fileloc.getNodeLength();
                            Display.getDefault().asyncExec(new Runnable(this, (IPath)path, offset, length){
                                final /* synthetic */ Runner this$1;
                                private final /* synthetic */ IPath val$path;
                                private final /* synthetic */ int val$offset;
                                private final /* synthetic */ int val$length;
                                {
                                    this.this$1 = runner;
                                    this.val$path = iPath;
                                    this.val$offset = n;
                                    this.val$length = n2;
                                }

                                public void run() {
                                    try {
                                        Runner.access$0(this.this$1).open(this.val$path, this.val$offset, this.val$length);
                                    }
                                    catch (CoreException e) {
                                        CUIPlugin.getDefault().log(e);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var15_20 = null;
                    pdom.releaseReadLock();
                    throw throwable;
                }
                {
                    Object var15_21 = null;
                }
                pdom.releaseReadLock();
                return Status.OK_STATUS;
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ OpenDeclarationsAction access$0(Runner runner) {
            return runner.OpenDeclarationsAction.this;
        }
    }
}

