/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICompletionContributor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class DOMCompletionContributor
implements ICompletionContributor {
    public void contributeCompletionProposals(ITextViewer viewer, int offset, IWorkingCopy workingCopy, ASTCompletionNode completionNode, String prefix, List proposals) {
        if (completionNode != null) {
            IASTPreprocessorMacroDefinition[] macros;
            IASTName[] names = completionNode.getNames();
            if (names == null || names.length == 0) {
                return;
            }
            ArrayList<IBinding> allBindings = new ArrayList<IBinding>();
            int i = 0;
            while (i < names.length) {
                IBinding[] bindings;
                if (names[i].getTranslationUnit() != null && (bindings = names[i].resolvePrefix()) != null) {
                    int j = 0;
                    while (j < bindings.length) {
                        IBinding binding = bindings[j];
                        allBindings.add(binding);
                        ++j;
                    }
                }
                ++i;
            }
            Iterator iBinding = allBindings.iterator();
            while (iBinding.hasNext()) {
                IBinding binding = (IBinding)iBinding.next();
                this.handleBinding(binding, completionNode, offset, viewer, proposals);
            }
            if (prefix.length() > 0 && (macros = completionNode.getTranslationUnit().getMacroDefinitions()) != null) {
                int i2 = 0;
                while (i2 < macros.length) {
                    if (macros[i2].getName().toString().startsWith(prefix)) {
                        this.handleMacro(macros[i2], completionNode, offset, viewer, proposals);
                    }
                    ++i2;
                }
            }
        }
    }

    protected void handleBinding(IBinding binding, ASTCompletionNode completionNode, int offset, ITextViewer viewer, List proposals) {
        if (binding instanceof IFunction) {
            this.handleFunction((IFunction)binding, completionNode, offset, viewer, proposals);
        } else if (binding instanceof IVariable) {
            this.handleVariable((IVariable)binding, completionNode, offset, viewer, proposals);
        } else {
            proposals.add(this.createProposal(binding.getName(), binding.getName(), this.getImage(binding), completionNode, offset, viewer));
        }
    }

    private void handleFunction(IFunction function, ASTCompletionNode completionNode, int offset, ITextViewer viewer, List proposals) {
        Image image = this.getImage(CElementImageProvider.getFunctionImageDescriptor());
        StringBuffer repStringBuff = new StringBuffer();
        repStringBuff.append(function.getName());
        repStringBuff.append('(');
        StringBuffer dispargs = new StringBuffer();
        StringBuffer idargs = new StringBuffer();
        String returnTypeStr = null;
        try {
            IType returnType;
            IParameter[] params = function.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    IType paramType = params[i].getType();
                    if (i > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append(ASTTypeUtil.getType((IType)paramType));
                    idargs.append(ASTTypeUtil.getType((IType)paramType));
                    String paramName = params[i].getName();
                    if (paramName != null && paramName.length() > 0) {
                        dispargs.append(' ');
                        dispargs.append(paramName);
                    }
                    ++i;
                }
            }
            if (function.takesVarArgs()) {
                if (params.length > 0) {
                    dispargs.append(',');
                    idargs.append(',');
                }
                dispargs.append("...");
                idargs.append("...");
            } else if (params.length == 0) {
                dispargs.append("void");
                idargs.append("void");
            }
            IFunctionType functionType = function.getType();
            if (functionType != null && (returnType = functionType.getReturnType()) != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)returnType);
            }
        }
        catch (DOMException dOMException) {}
        String dispargString = dispargs.toString();
        String idargString = idargs.toString();
        StringBuffer dispStringBuff = new StringBuffer(repStringBuff.toString());
        dispStringBuff.append(dispargString);
        dispStringBuff.append(')');
        if (returnTypeStr != null) {
            dispStringBuff.append(' ');
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuffer idStringBuff = new StringBuffer(repStringBuff.toString());
        idStringBuff.append(idargString);
        idStringBuff.append(')');
        String idString = idStringBuff.toString();
        repStringBuff.append(')');
        String repString = repStringBuff.toString();
        int repLength = completionNode.getLength();
        int repOffset = offset - repLength;
        CCompletionProposal proposal = new CCompletionProposal(repString, repOffset, repLength, image, dispString, idString, 1, viewer);
        proposal.setCursorPosition(repString.length() - 1);
        if (dispargString.length() > 0) {
            CProposalContextInformation info = new CProposalContextInformation(repString, dispargString);
            info.setContextInformationPosition(offset);
            proposal.setContextInformation(info);
        }
        proposals.add(proposal);
    }

    private void handleVariable(IVariable variable, ASTCompletionNode completionNode, int offset, ITextViewer viewer, List proposals) {
        StringBuffer repStringBuff = new StringBuffer();
        repStringBuff.append(variable.getName());
        String returnTypeStr = "<unknown>";
        try {
            IType varType = variable.getType();
            if (varType != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)varType);
            }
        }
        catch (DOMException dOMException) {}
        StringBuffer dispStringBuff = new StringBuffer(repStringBuff.toString());
        if (returnTypeStr != null) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuffer idStringBuff = new StringBuffer(repStringBuff.toString());
        String idString = idStringBuff.toString();
        String repString = repStringBuff.toString();
        int repLength = completionNode.getLength();
        int repOffset = offset - repLength;
        CCompletionProposal proposal = new CCompletionProposal(repString, repOffset, repLength, null, dispString, idString, 1, viewer);
        proposals.add(proposal);
    }

    private void handleMacro(IASTPreprocessorMacroDefinition macro, ASTCompletionNode completionNode, int offset, ITextViewer viewer, List proposals) {
        String macroName = macro.getName().toString();
        Image image = this.getImage(CElementImageProvider.getMacroImageDescriptor());
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition functionMacro = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            StringBuffer repStringBuff = new StringBuffer();
            repStringBuff.append(macroName);
            repStringBuff.append('(');
            StringBuffer args = new StringBuffer();
            IASTFunctionStyleMacroParameter[] params = functionMacro.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        args.append(", ");
                    }
                    args.append(params[i].getParameter());
                    ++i;
                }
            }
            String argString = args.toString();
            StringBuffer descStringBuff = new StringBuffer(repStringBuff.toString());
            descStringBuff.append(argString);
            descStringBuff.append(')');
            repStringBuff.append(')');
            String repString = repStringBuff.toString();
            String descString = descStringBuff.toString();
            CCompletionProposal proposal = this.createProposal(repString, descString, image, completionNode, offset, viewer);
            proposal.setCursorPosition(repString.length() - 1);
            if (argString.length() > 0) {
                CProposalContextInformation info = new CProposalContextInformation(repString, argString);
                info.setContextInformationPosition(offset);
                proposal.setContextInformation(info);
            }
            proposals.add(proposal);
        } else {
            proposals.add(this.createProposal(macroName, macroName, image, completionNode, offset, viewer));
        }
    }

    private CCompletionProposal createProposal(String repString, String dispString, Image image, ASTCompletionNode completionNode, int offset, ITextViewer viewer) {
        int repLength = completionNode.getLength();
        int repOffset = offset - repLength;
        return new CCompletionProposal(repString, repOffset, repLength, image, dispString, 1, viewer);
    }

    private Image getImage(ImageDescriptor desc) {
        return desc != null ? CUIPlugin.getImageDescriptorRegistry().get(desc) : null;
    }

    private Image getImage(IBinding binding) {
        ImageDescriptor imageDescriptor = null;
        try {
            ICPPDelegate[] delegates;
            if (binding instanceof ITypedef) {
                imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
            } else if (binding instanceof ICompositeType) {
                if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                    imageDescriptor = CElementImageProvider.getClassImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 1) {
                    imageDescriptor = CElementImageProvider.getStructImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 2) {
                    imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
                }
            } else if (binding instanceof IFunction) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPField) {
                switch (((ICPPField)binding).getVisibility()) {
                    case 3: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PRIVATE);
                        break;
                    }
                    case 2: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PROTECTED);
                        break;
                    }
                    default: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
                        break;
                    }
                }
            } else if (binding instanceof IVariable) {
                imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
            } else if (binding instanceof IEnumerator) {
                imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
            } else if (binding instanceof ICPPNamespace) {
                imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
            } else if (binding instanceof ICPPFunctionTemplate) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
                return this.getImage((IBinding)delegates[0]);
            }
        }
        catch (DOMException dOMException) {}
        return imageDescriptor != null ? CUIPlugin.getImageDescriptorRegistry().get(imageDescriptor) : null;
    }
}

