/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final int LABEL_FLAGS = 202713775;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return CUIMessages.getFormattedString("StatusBarUpdater.num_elements_selected", String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof ICElement) {
                return this.formatCElementMessage((ICElement)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
        }
        return "";
    }

    private String formatCElementMessage(ICElement element) {
        return CElementLabels.getElementLabel(element, 202713775);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + CElementLabels.CONCAT_STRING + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }
}

