/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class SelectWorkingSetAction
extends Action {
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        super(WorkingSetMessages.getString("SelectWorkingSetAction.text"));
        Assert.isNotNull((Object)((Object)actionGroup));
        this.setToolTipText(WorkingSetMessages.getString("SelectWorkingSetAction.toolTip"));
        this.fShell = shell;
        this.fActionGroup = actionGroup;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.select_working_set_action");
    }

    public void run() {
        if (this.fShell == null) {
            this.fShell = CUIPlugin.getActiveWorkbenchShell();
        }
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.fShell, false);
        IWorkingSet workingSet = this.fActionGroup.getWorkingSet();
        if (workingSet != null) {
            dialog.setSelection(new IWorkingSet[]{workingSet});
        }
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result != null && result.length > 0) {
                this.fActionGroup.setWorkingSet(result[0], true);
                manager.addRecentWorkingSet(result[0]);
            } else {
                this.fActionGroup.setWorkingSet(null, true);
            }
        }
    }
}

