/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MakeBuilderUtil {
    public static IPath getBuildDirectory(IProject project, IPath subPath, String builderID) {
        IPath rootPath = MakeBuilderUtil.getBuildDirectory(project, builderID);
        return rootPath.append(subPath);
    }

    public static IPath getBuildDirectory(IProject project, String builderID) {
        IMakeBuilderInfo info;
        try {
            info = MakeCorePlugin.createBuildInfo(project, builderID);
        }
        catch (CoreException coreException) {
            return project.getLocation();
        }
        return MakeBuilderUtil.getBuildDirectory(project, info);
    }

    public static IPath getBuildDirectory(IProject project, IMakeBuilderInfo info) {
        IPath buildDirectory = info.getBuildLocation();
        if (!buildDirectory.isEmpty()) {
            IResource res = project.getParent().findMember(buildDirectory);
            if (res instanceof IContainer && res.exists()) {
                buildDirectory = res.getLocation();
            }
        } else {
            buildDirectory = project.getLocation();
        }
        return buildDirectory;
    }
}

