/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.BuildInfoFactory;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefile;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigInfoFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MakeCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.make.core";
    public static final String MAKE_PROJECT_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".make";
    public static final String OLD_BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    public static final String EXTERNAL_SI_PROVIDER_SIMPLE_ID = "ExternalScannerInfoProvider";
    public static final String SI_CONSOLE_PARSER_SIMPLE_ID = "ScannerInfoConsoleParser";
    public static final String DEFAULT_EXTERNAL_SI_PROVIDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".DefaultExternalScannerInfoProvider";
    public static final String GCC_SPECS_CONSOLE_PARSER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCSpecsConsoleParser";
    public static final String GCC_SCANNER_INFO_CONSOLE_PARSER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCScannerInfoConsoleParser";
    public static final String MAKEFILE_STYLE = "org.eclipse.cdt.make.coreeditor_makefile_style";
    public static final String MAKEFILE_DIRS = "org.eclipse.cdt.make.coreeditor_makefile_dirs";
    private MakeTargetManager fTargetManager;
    private DiscoveredPathManager fDiscoveryPathManager;
    private static MakeCorePlugin plugin;
    private static final String SCANNER_CONFIG;

    static {
        SCANNER_CONFIG = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + "/debug/scdiscovery";
    }

    public MakeCorePlugin() {
        plugin = this;
    }

    public static MakeCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, MakeCorePlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        MakeCorePlugin.log(status);
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static String getUniqueIdentifier() {
        if (MakeCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MakeCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IMakeBuilderInfo createBuildInfo(Preferences prefs, String builderID, boolean useDefaults) {
        return BuildInfoFactory.create(prefs, builderID, useDefaults);
    }

    public static IMakeBuilderInfo createBuildInfo(IProject project, String builderID) throws CoreException {
        return BuildInfoFactory.create(project, builderID);
    }

    public static IMakeBuilderInfo createBuildInfo(Map args, String builderID) {
        return BuildInfoFactory.create(args, builderID);
    }

    public IMakeTargetManager getTargetManager() {
        if (this.fTargetManager == null) {
            this.fTargetManager = new MakeTargetManager();
            this.fTargetManager.startup();
        }
        return this.fTargetManager;
    }

    public boolean isMakefileGNUStyle() {
        String style = this.getPluginPreferences().getString(MAKEFILE_STYLE);
        return style != null && style.equalsIgnoreCase("GNU");
    }

    public String[] getMakefileDirs() {
        String stringList = this.getPluginPreferences().getString(MAKEFILE_DIRS);
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<Object> v = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement());
        }
        return v.toArray(new String[v.size()]);
    }

    public IMakefile createMakefile(IFile file) {
        AbstractMakefile makefile;
        if (this.isMakefileGNUStyle()) {
            GNUMakefile gnu = new GNUMakefile();
            ArrayList<String> includeList = new ArrayList<String>();
            includeList.addAll(Arrays.asList(gnu.getIncludeDirectories()));
            includeList.addAll(Arrays.asList(this.getMakefileDirs()));
            includeList.add(file.getLocation().removeLastSegments(1).toOSString());
            String[] includes = includeList.toArray(new String[includeList.size()]);
            gnu.setIncludeDirectories(includes);
            try {
                gnu.parse(file.getLocation().toOSString());
            }
            catch (IOException iOException) {}
            makefile = gnu;
        } else {
            PosixMakefile posix = new PosixMakefile();
            try {
                posix.parse(file.getLocation().toOSString());
            }
            catch (IOException iOException) {}
            makefile = posix;
        }
        return makefile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fTargetManager != null) {
                this.fTargetManager.shutdown();
                this.fTargetManager = null;
            }
            if (this.fDiscoveryPathManager != null) {
                this.fDiscoveryPathManager.shutdown();
                this.fDiscoveryPathManager = null;
            }
            this.savePluginPreferences();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(Preferences prefs, String builderID, boolean useDefaults) {
        return ScannerConfigInfoFactory.create(prefs, builderID, useDefaults);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(IProject project, String builderID) throws CoreException {
        return ScannerConfigInfoFactory.create(project, builderID);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(Map args, String builderID) {
        return ScannerConfigInfoFactory.create(args, builderID);
    }

    public static IPath getWorkingDirectory() {
        return MakeCorePlugin.getDefault().getStateLocation();
    }

    public IDiscoveredPathManager getDiscoveryManager() {
        if (this.fDiscoveryPathManager == null) {
            this.fDiscoveryPathManager = new DiscoveredPathManager();
            this.fDiscoveryPathManager.startup();
        }
        return this.fDiscoveryPathManager;
    }

    public IExternalScannerInfoProvider getExternalScannerInfoProvider(String id) {
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, EXTERNAL_SI_PROVIDER_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    String tool = extensions[i].getUniqueIdentifier();
                    if (tool != null && tool.equals(id)) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            IConfigurationElement[] runElement = configElements[j].getChildren("run");
                            if (runElement.length > 0) {
                                IExternalScannerInfoProvider builder = (IExternalScannerInfoProvider)runElement[0].createExecutableExtension("class");
                                return builder;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
        return null;
    }

    public String[] getScannerInfoConsoleParserIds(String commandId) {
        IExtensionPoint extension;
        String[] empty = new String[]{};
        if (commandId == null || commandId.length() == 0) {
            commandId = "all";
        }
        if ((extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SI_CONSOLE_PARSER_SIMPLE_ID)) != null) {
            IExtension[] extensions = extension.getExtensions();
            ArrayList<String> parserIds = new ArrayList<String>(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements;
                String id;
                String parserId = extensions[i].getUniqueIdentifier();
                if (parserId != null && (id = (configElements = extensions[i].getConfigurationElements())[0].getAttribute("commandId")) != null && (id.equals(commandId) || id.equals("all"))) {
                    parserIds.add(parserId);
                }
                ++i;
            }
            return parserIds.toArray(empty);
        }
        return empty;
    }

    public IScannerInfoConsoleParser getScannerInfoConsoleParser(String parserId) {
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SI_CONSOLE_PARSER_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    String id = extensions[i].getUniqueIdentifier();
                    if (id != null && id.equals(parserId)) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        IScannerInfoConsoleParser parser = (IScannerInfoConsoleParser)configElements[0].createExecutableExtension("class");
                        return parser;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        GCCScannerConfigUtil.createSpecs();
    }

    private void configurePluginDebugOptions() {
        String option;
        if (this.isDebugging() && (option = Platform.getDebugOption((String)SCANNER_CONFIG)) != null) {
            TraceUtil.SCANNER_CONFIG = option.equalsIgnoreCase("true");
        }
    }
}

