/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectTargets {
    private static final String MAKE_TARGET_KEY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".buildtargets";
    private static final String TARGETS_EXT = "targets";
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String BAD_TARGET = "buidlTarget";
    private static final String TARGET = "buildTarget";
    private HashMap targetMap = new HashMap();
    private IProject project;

    public ProjectTargets(MakeTargetManager manager, IProject project) {
        boolean writeTargets = false;
        File targetFile = null;
        this.project = project;
        Document document = this.translateCDTProjectToDocument();
        if (document == null || !document.hasChildNodes()) {
            IPath targetFilePath = MakeCorePlugin.getDefault().getStateLocation().append(project.getName()).addFileExtension(TARGETS_EXT);
            targetFile = targetFilePath.toFile();
            try {
                FileInputStream input = new FileInputStream(targetFile);
                document = this.translateInputStreamToDocument(input);
                writeTargets = true;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (document != null) {
            this.extractMakeTargetsFromDocument(document, manager);
            if (writeTargets) {
                try {
                    Document doc = this.getAsXML();
                    this.translateDocumentToCDTProject(doc);
                }
                catch (Exception exception) {
                    targetFile = null;
                }
                if (targetFile != null) {
                    targetFile.delete();
                }
            }
        }
    }

    protected String getString(Node target, String tagName) {
        Node node = this.searchNode(target, tagName);
        return node != null ? (node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue()) : null;
    }

    protected Node searchNode(Node target, String tagName) {
        NodeList list = target.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeName().equals(tagName)) {
                return list.item(i);
            }
            ++i;
        }
        return null;
    }

    public IMakeTarget[] get(IContainer container) {
        ArrayList list = (ArrayList)this.targetMap.get(container);
        if (list != null) {
            return list.toArray(new IMakeTarget[list.size()]);
        }
        return new IMakeTarget[0];
    }

    public IMakeTarget findTarget(IContainer container, String name) {
        ArrayList list = (ArrayList)this.targetMap.get(container);
        if (list != null) {
            Iterator targets = list.iterator();
            while (targets.hasNext()) {
                IMakeTarget target = (IMakeTarget)targets.next();
                if (!target.getName().equals(name)) continue;
                return target;
            }
        }
        return null;
    }

    public void add(MakeTarget target) throws CoreException {
        ArrayList<MakeTarget> list = (ArrayList<MakeTarget>)this.targetMap.get(target.getContainer());
        if (list != null && list.contains(target)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.target_exists"), null));
        }
        if (list == null) {
            list = new ArrayList<MakeTarget>();
            this.targetMap.put(target.getContainer(), list);
        }
        list.add(target);
    }

    public boolean contains(MakeTarget target) {
        ArrayList list = (ArrayList)this.targetMap.get(target.getContainer());
        return list != null && list.contains(target);
    }

    public boolean remove(MakeTarget target) {
        ArrayList list = (ArrayList)this.targetMap.get(target.getContainer());
        if (list == null || !list.contains(target)) {
            return false;
        }
        boolean found = list.remove(target);
        if (list.size() == 0) {
            this.targetMap.remove(list);
        }
        return found;
    }

    public IProject getProject() {
        return this.project;
    }

    protected Document getAsXML() throws CoreException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, "Error creating new XML storage document", (Throwable)ex));
        }
        Element targetsRootElement = doc.createElement(BUILD_TARGET_ELEMENT);
        doc.appendChild(targetsRootElement);
        Iterator container = this.targetMap.entrySet().iterator();
        while (container.hasNext()) {
            List targets = (List)container.next().getValue();
            int i = 0;
            while (i < targets.size()) {
                MakeTarget target = (MakeTarget)targets.get(i);
                targetsRootElement.appendChild(this.createTargetElement(doc, target));
                ++i;
            }
        }
        return doc;
    }

    private Node createTargetElement(Document doc, MakeTarget target) {
        Element targetElem = doc.createElement(TARGET_ELEMENT);
        targetElem.setAttribute(TARGET_ATTR_NAME, target.getName());
        targetElem.setAttribute(TARGET_ATTR_ID, target.getTargetBuilderID());
        targetElem.setAttribute(TARGET_ATTR_PATH, target.getContainer().getProjectRelativePath().toString());
        Element elem = doc.createElement(TARGET_COMMAND);
        targetElem.appendChild(elem);
        elem.appendChild(doc.createTextNode(target.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make")));
        String targetAttr = target.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, null);
        if (targetAttr != null) {
            elem = doc.createElement(TARGET_ARGUMENTS);
            elem.appendChild(doc.createTextNode(targetAttr));
            targetElem.appendChild(elem);
        }
        if ((targetAttr = target.getBuildAttribute(IMakeTarget.BUILD_TARGET, null)) != null) {
            elem = doc.createElement(TARGET);
            elem.appendChild(doc.createTextNode(targetAttr));
            targetElem.appendChild(elem);
        }
        elem = doc.createElement(TARGET_STOP_ON_ERROR);
        elem.appendChild(doc.createTextNode(new Boolean(target.isStopOnError()).toString()));
        targetElem.appendChild(elem);
        elem = doc.createElement(TARGET_USE_DEFAULT_CMD);
        elem.appendChild(doc.createTextNode(new Boolean(target.isDefaultBuildCmd()).toString()));
        targetElem.appendChild(elem);
        return targetElem;
    }

    public void saveTargets() throws CoreException {
        Document doc = this.getAsXML();
        this.translateDocumentToCDTProject(doc);
    }

    protected void saveTargets(Document doc, OutputStream output) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(output);
        transformer.transform(source, outputTarget);
    }

    protected void translateDocumentToCDTProject(Document doc) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
        Element rootElement = descriptor.getProjectData(MAKE_TARGET_KEY);
        NodeList kids = rootElement.getChildNodes();
        int i = 0;
        while (i < kids.getLength()) {
            rootElement.removeChild(kids.item(i));
            --i;
            ++i;
        }
        Node node = doc.getFirstChild();
        if (node.hasChildNodes()) {
            Node appendNode = rootElement.getOwnerDocument().importNode(node, true);
            rootElement.appendChild(appendNode);
        }
        descriptor.saveProjectData();
    }

    protected Document translateCDTProjectToDocument() {
        Document document = null;
        Element rootElement = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
            rootElement = descriptor.getProjectData(MAKE_TARGET_KEY);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return document;
        }
        catch (CoreException coreException) {
            return document;
        }
        NodeList list = rootElement.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Node appendNode = document.importNode(list.item(i), true);
                document.appendChild(appendNode);
                break;
            }
            ++i;
        }
        return document;
    }

    protected Document translateInputStreamToDocument(InputStream input) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        }
        catch (Exception e) {
            MakeCorePlugin.log(e);
        }
        return document;
    }

    protected void extractMakeTargetsFromDocument(Document document, MakeTargetManager manager) {
        Node node = document.getFirstChild();
        if (node != null && node.getNodeName().equals(BUILD_TARGET_ELEMENT)) {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                node = list.item(i);
                if (node.getNodeName().equals(TARGET_ELEMENT)) {
                    Object container = null;
                    NamedNodeMap attr = node.getAttributes();
                    String path = attr.getNamedItem(TARGET_ATTR_PATH).getNodeValue();
                    container = path != null && !path.equals("") ? this.project.getFolder(path) : this.project;
                    try {
                        MakeTarget target = new MakeTarget(manager, this.project, attr.getNamedItem(TARGET_ATTR_ID).getNodeValue(), attr.getNamedItem(TARGET_ATTR_NAME).getNodeValue());
                        target.setContainer((IContainer)container);
                        String option = this.getString(node, TARGET_STOP_ON_ERROR);
                        if (option != null) {
                            target.setStopOnError(Boolean.valueOf(option));
                        }
                        if ((option = this.getString(node, TARGET_USE_DEFAULT_CMD)) != null) {
                            target.setUseDefaultBuildCmd(Boolean.valueOf(option));
                        }
                        if ((option = this.getString(node, TARGET_COMMAND)) != null) {
                            target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, option);
                        }
                        if ((option = this.getString(node, TARGET_ARGUMENTS)) != null) {
                            target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, option);
                        }
                        if ((option = this.getString(node, BAD_TARGET)) != null) {
                            target.setBuildAttribute(IMakeTarget.BUILD_TARGET, option);
                        }
                        if ((option = this.getString(node, TARGET)) != null) {
                            target.setBuildAttribute(IMakeTarget.BUILD_TARGET, option);
                        }
                        this.add(target);
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log(e);
                    }
                }
                ++i;
            }
        }
    }
}

