/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.text.source.Annotation;

public class DisassemblyInstructionPointerAnnotation
extends Annotation {
    private int fHashCode = 0;

    public DisassemblyInstructionPointerAnnotation(ICStackFrame stackFrame, boolean isTopFrame) {
        super(isTopFrame ? IInternalCDebugUIConstants.ANN_DISASM_INSTR_POINTER_CURRENT : IInternalCDebugUIConstants.ANN_DISASM_INSTR_POINTER_SECONDARY, false, isTopFrame ? DisassemblyMessages.getString("DisassemblyInstructionPointerAnnotation.Current_Pointer_1") : DisassemblyMessages.getString("DisassemblyInstructionPointerAnnotation.Secondary_Pointer_1"));
        this.fHashCode = this.getHashCode(stackFrame);
    }

    private IDisassembly getDisassembly(ICStackFrame frame) {
        if (frame != null) {
            ICDebugTarget target = (ICDebugTarget)frame.getDebugTarget();
            try {
                return target.getDisassembly();
            }
            catch (DebugException debugException) {}
        }
        return null;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    private int getHashCode(ICStackFrame frame) {
        int hashCode = 17;
        IDisassembly disassembly = this.getDisassembly(frame);
        hashCode = 37 * hashCode + (disassembly != null ? disassembly.hashCode() : 0);
        if (frame != null) {
            IAddress address = frame.getAddress();
            hashCode = 37 * hashCode + address.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return obj != null ? obj.hashCode() == this.hashCode() : false;
    }
}

