/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.simulation.ui.preferences;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.PreferenceConstants;
import org.eclipse.ptp.internal.core.CoreMessages;
import org.eclipse.ptp.rtsystem.simulation.SimulationControlSystem;
import org.eclipse.ptp.rtsystem.simulation.SimulationMonitoringSystem;
import org.eclipse.ptp.simulation.ui.preferences.ManagedCProjectCreation;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SimulationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    public static final String EMPTY_STRING = "";
    protected Spinner spin = null;
    protected Text nodeText = null;
    protected Combo mcombo = null;
    protected Label nodeLabel = null;
    protected int[] nodes;
    protected WidgetListener listener = new WidgetListener();

    public SimulationPreferencePage() {
        this.setPreferenceStore(PTPCorePlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createMyContents(composite);
        this.createSimulationProject(composite);
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    private void createSimulationProject(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(3, false, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(CoreMessages.getResourceString((String)"SimulationPreferencesPage.group_simulation"));
        new Label((Composite)aGroup, 0).setText(CoreMessages.getResourceString((String)"SimulationPreferencesPage.createSimulationProject_combo"));
        final Combo projectCombo = new Combo((Composite)aGroup, 8);
        projectCombo.add("C");
        Button createSimulationButton = new Button((Composite)aGroup, 8);
        createSimulationButton.setText(CoreMessages.getResourceString((String)"SimulationPreferencesPage.createSimulationProject_button"));
        createSimulationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (projectCombo.getSelectionIndex() > -1) {
                    ManagedCProjectCreation simulationProject = new ManagedCProjectCreation("PTPSimulation", "main");
                    try {
                        simulationProject.createSimulatorProject();
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)SimulationPreferencePage.this.getShell(), (String)CoreMessages.getResourceString((String)"SimulationPreferencePage.ErrorFound"), (String)CoreMessages.getResourceString((String)"SimulationPreferencePage.CannotCreateProject"), (IStatus)e.getStatus());
                    }
                }
            }
        });
    }

    private void createMyContents(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(CoreMessages.getResourceString((String)"SimulationPreferencesPage.group_main"));
        Label ortedComment = new Label((Composite)aGroup, 64);
        ortedComment.setText(CoreMessages.getResourceString((String)"SimulationPreferencePage.NumSimulatedMachines"));
        this.spin = new Spinner((Composite)aGroup, 8);
        this.spin.setMinimum(1);
        this.spin.addModifyListener((ModifyListener)this.listener);
        Group bGroup = new Group(parent, 16);
        bGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        bGroup.setLayoutData((Object)this.spanGridData(768, 2));
        bGroup.setText(CoreMessages.getResourceString((String)"SimulationPreferencesPage.group_machines"));
        new Label((Composite)bGroup, 0).setText(CoreMessages.getResourceString((String)"SimulationPreferencePage.SelectMachine"));
        this.mcombo = new Combo((Composite)bGroup, 8);
        this.mcombo.addSelectionListener((SelectionListener)this.listener);
        this.nodeLabel = new Label((Composite)bGroup, 0);
        this.nodeLabel.setText(CoreMessages.getResourceString((String)"SimulationPreferencePage.NumNodesMachine_0"));
        this.nodeLabel.setLayoutData((Object)this.spanGridData(768, 2));
        this.nodeText = new Text((Composite)bGroup, 2052);
        this.nodeText.setLayoutData((Object)this.spanGridData(768, 2));
        this.nodeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.nodeText.addModifyListener((ModifyListener)this.listener);
        this.setupMachineRegion();
        this.mcombo.select(0);
    }

    protected void setupMachineRegion() {
        int choice = this.spin.getSelection();
        int sel = this.mcombo.getSelectionIndex();
        if (this.nodes != null) {
            int l = this.nodes.length;
            int[] nodesold = new int[l];
            int i = 0;
            while (i < l) {
                nodesold[i] = this.nodes[i];
                ++i;
            }
            this.nodes = new int[choice];
            i = 0;
            while (i < choice) {
                this.nodes[i] = i < l ? nodesold[i] : 1;
                ++i;
            }
        }
        this.mcombo.removeAll();
        int i = 0;
        while (i < choice) {
            this.mcombo.add(String.valueOf(CoreMessages.getResourceString((String)"SimulationPreferencePage.Machine")) + i);
            ++i;
        }
        if (sel < choice && sel >= 0) {
            this.mcombo.select(sel);
        } else if (sel == choice && sel != 0) {
            this.mcombo.select(sel - 1);
        } else {
            this.mcombo.select(0);
        }
        this.mcombo.pack();
        sel = this.mcombo.getSelectionIndex();
        this.nodeLabel.setText(String.valueOf(CoreMessages.getResourceString((String)"SimulationPreferencePage.NumNodesMachine")) + sel + ":");
        if (this.nodes != null) {
            this.nodeText.setText(EMPTY_STRING + this.nodes[sel]);
        }
    }

    protected void defaultSetting() {
    }

    private void loadSaved() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        int numMachines = preferences.getInt("SIMULATION_NUM_MACHINES");
        if (numMachines < 1) {
            numMachines = 1;
        }
        this.spin.setSelection(numMachines);
        this.nodes = new int[numMachines];
        int i = 0;
        while (i < numMachines) {
            int nnodes = preferences.getInt("SIMULATION_MACHINE_NODE_" + i);
            if (nnodes < 1) {
                nnodes = 1;
            }
            this.nodes[i] = nnodes;
            ++i;
        }
        this.nodeText.setText(EMPTY_STRING + this.nodes[0]);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    public boolean performOk() {
        int nmacs = this.spin.getSelection();
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        preferences.setValue("SIMULATION_NUM_MACHINES", nmacs);
        int i = 0;
        while (i < nmacs) {
            preferences.setValue("SIMULATION_MACHINE_NODE_" + i, this.nodes[i]);
            ++i;
        }
        PTPCorePlugin.getDefault().savePluginPreferences();
        IModelManager manager = PTPCorePlugin.getDefault().getModelManager();
        if (manager.getMonitoringSystem() instanceof SimulationMonitoringSystem && manager.getControlSystem() instanceof SimulationControlSystem) {
            PTPUIPlugin.getDefault().refreshRuntimeSystem(true, true);
        }
        return true;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setValid(true);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == SimulationPreferencePage.this.mcombo) {
                SimulationPreferencePage.this.setupMachineRegion();
            }
            SimulationPreferencePage.this.updatePreferencePage();
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (source == SimulationPreferencePage.this.spin) {
                SimulationPreferencePage.this.setupMachineRegion();
            } else if (source == SimulationPreferencePage.this.nodeText) {
                int mac = SimulationPreferencePage.this.mcombo.getSelectionIndex();
                String sval = SimulationPreferencePage.this.nodeText.getText();
                int val = 1;
                try {
                    val = new Integer(sval);
                }
                catch (NumberFormatException numberFormatException) {}
                SimulationPreferencePage.this.nodes[mac] = val;
            }
            SimulationPreferencePage.this.updatePreferencePage();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                SimulationPreferencePage.this.updatePreferencePage();
            }
        }
    }
}

