/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.simulation.ui.wizards;

import org.eclipse.ptp.rmsystem.SimulationRMConfiguration;
import org.eclipse.ptp.simulation.internal.ui.Messages;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SimulationRMConfigurationWizardPage
extends RMConfigurationWizardPage {
    private static final int TEXT_WIDTH = 50;
    private SimulationRMConfiguration config;
    private Combo whichMachineCombo;
    private Text numNodesText;
    private Text numMachinesText;

    public SimulationRMConfigurationWizardPage(RMConfigurationWizard wizard) {
        super(wizard, Messages.getString("SimulationRMConfigurationWizardPage.name"));
        this.setTitle(Messages.getString("SimulationRMConfigurationWizardPage.title"));
        this.setDescription(Messages.getString("SimulationRMConfigurationWizardPage.description"));
        RMConfigurationWizard confWizard = this.getConfigurationWizard();
        this.config = (SimulationRMConfiguration)confWizard.getConfiguration();
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        System.out.println("In SimulationRMConfigurationWizardPage.createControl");
        Group machineGroup = new Group(parent, 16);
        machineGroup.setLayout((Layout)new GridLayout(1, false));
        machineGroup.setText(Messages.getString("SimulationRMConfigurationWizardPage.SimulatedMachineSettings"));
        Label label = new Label((Composite)machineGroup, 0);
        label.setText(Messages.getString("SimulationRMConfigurationWizardPage.NumberOfMachines"));
        VerifyListener intTextVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        };
        this.numMachinesText = new Text((Composite)machineGroup, 2052);
        this.numMachinesText.setLayoutData((Object)new GridData(50, -1));
        this.numMachinesText.addVerifyListener(intTextVerifyListener);
        this.numMachinesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimulationRMConfigurationWizardPage.this.setNumMachines(SimulationRMConfigurationWizardPage.this.numMachinesText.getText());
                SimulationRMConfigurationWizardPage.this.validate();
            }
        });
        Label whichMachineLabel = new Label((Composite)machineGroup, 0);
        whichMachineLabel.setText(Messages.getString("SimulationRMConfigurationWizardPage.SetNumberOfNodesWhichMachine"));
        int maxItemLength = this.getWhichMachineComboLength(machineGroup.getShell());
        this.whichMachineCombo = new Combo((Composite)machineGroup, 8);
        this.whichMachineCombo.setLayoutData((Object)new GridData(maxItemLength, -1));
        this.whichMachineCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimulationRMConfigurationWizardPage.this.setWhichMachine();
            }
        });
        this.numNodesText = new Text((Composite)machineGroup, 2052);
        this.numNodesText.setLayoutData((Object)new GridData(50, -1));
        this.numNodesText.addVerifyListener(intTextVerifyListener);
        this.numNodesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int whichMachine = SimulationRMConfigurationWizardPage.this.whichMachineCombo.getSelectionIndex();
                SimulationRMConfigurationWizardPage.this.setNumNodes(whichMachine, SimulationRMConfigurationWizardPage.this.numNodesText.getText());
                SimulationRMConfigurationWizardPage.this.validate();
            }
        });
        this.setControl((Control)machineGroup);
        this.whichMachineCombo.setEnabled(false);
        this.numNodesText.setEnabled(false);
    }

    private String[] getMachineNames(int numMachines) {
        String[] strs = new String[numMachines];
        int i = 0;
        while (i < numMachines) {
            strs[i] = String.valueOf(Messages.getString("SimulationRMConfigurationWizardPage.Machine")) + Integer.toString(i);
            ++i;
        }
        return strs;
    }

    private int getWhichMachineComboLength(Shell shell) {
        String maxItem = String.valueOf(Messages.getString("SimulationRMConfigurationWizardPage.Machine")) + "00000";
        GC gc = new GC((Drawable)shell);
        Point point = gc.stringExtent(maxItem);
        return point.x + 50;
    }

    private void setNumMachines(String nmStr) {
        try {
            int value = Integer.parseInt(nmStr);
            if (value >= 0) {
                this.config.setNumMachines(value);
            } else {
                this.config.setNumMachines(-1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.config.setNumMachines(-1);
        }
        int numMachines = this.config.getNumMachines();
        boolean enabled = numMachines > 0;
        this.whichMachineCombo.setItems(new String[0]);
        this.whichMachineCombo.setEnabled(enabled);
        this.numNodesText.setEnabled(enabled);
        if (enabled) {
            this.whichMachineCombo.setItems(this.getMachineNames(numMachines));
            this.whichMachineCombo.select(0);
            this.numNodesText.setText(Integer.toString(this.config.getNumNodesPerMachine(0)));
        }
    }

    private void setNumNodes(int whichMachine, String nmStr) {
        try {
            int value = Integer.parseInt(nmStr);
            if (value >= 0) {
                this.config.setNumNodesPerMachine(whichMachine, value);
            } else {
                this.config.setNumNodesPerMachine(whichMachine, -1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.config.setNumNodesPerMachine(whichMachine, -1);
        }
    }

    private void setWhichMachine() {
        int whichMachine = this.whichMachineCombo.getSelectionIndex();
        this.numNodesText.setText(Integer.toString(this.config.getNumNodesPerMachine(whichMachine)));
    }

    private void validate() {
        boolean isValid = true;
        isValid = isValid && this.config.getNumMachines() >= 0;
        int i = 0;
        int n = this.config.getNumMachines();
        while (i < n) {
            int numNodes = this.config.getNumNodesPerMachine(i);
            isValid = isValid && numNodes >= 0;
            ++i;
        }
        this.setPageComplete(isValid);
    }
}

