/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.debug.internal.ui.PInstructionPointerAnnotation2;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;

public class AnnotationGroup {
    private List annotationList = Collections.synchronizedList(new ArrayList());

    public boolean contains(PInstructionPointerAnnotation2 annotation) {
        return this.annotationList.contains(annotation);
    }

    public void addAnnotation(PInstructionPointerAnnotation2 annotation) {
        if (!this.contains(annotation)) {
            this.annotationList.add(annotation);
        }
    }

    public void removeAnnotations(Collection removedAnnotations) {
        this.annotationList.removeAll(removedAnnotations);
    }

    public void removeAnnotation(PInstructionPointerAnnotation2 annotation) {
        if (this.contains(annotation)) {
            this.annotationList.remove(annotation);
        }
    }

    public void removeAnnotations() {
        this.throwAllAnnotations();
        this.annotationList.clear();
    }

    public int size() {
        return this.annotationList.size();
    }

    public Iterator getAnnotationIterator() {
        return this.annotationList.iterator();
    }

    public boolean isEmpty() {
        return this.annotationList.isEmpty();
    }

    public void throwAllAnnotations() {
        Iterator i = this.annotationList.iterator();
        while (i.hasNext()) {
            ((PInstructionPointerAnnotation2)i.next()).removeAnnotation();
        }
    }

    public void retrieveAllAnnontations() {
        for (PInstructionPointerAnnotation2 annotation : this.annotationList) {
            String type = annotation.getType();
            if (type.equals(IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT)) {
                type = IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT;
            }
            annotation.addAnnotationToModel();
            annotation.setMessage(!type.equals(IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT));
        }
    }
}

