/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.core.resources.FileStorage;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointHit;
import org.eclipse.ptp.debug.core.cdi.IPCDIExitInfo;
import org.eclipse.ptp.debug.core.cdi.IPCDISharedLibraryEvent;
import org.eclipse.ptp.debug.core.cdi.IPCDISignalExitInfo;
import org.eclipse.ptp.debug.core.cdi.IPCDISignalReceived;
import org.eclipse.ptp.debug.core.cdi.IPCDIWatchpointScope;
import org.eclipse.ptp.debug.core.cdi.IPCDIWatchpointTrigger;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.model.IEnableDisableTarget;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugElementStatus;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPDummyStackFrame;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPType;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.internal.ui.OverlayImageCache;
import org.eclipse.ptp.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.ptp.debug.internal.ui.PAnnotationManager;
import org.eclipse.ptp.debug.internal.ui.PDebugImage;
import org.eclipse.ptp.debug.internal.ui.PDebugUIMessages;
import org.eclipse.ptp.debug.internal.ui.PValueDetailProvider;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private static PDebugModelPresentation instance = null;
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String DUMMY_STACKFRAME_LABEL = "...";
    protected UIDebugManager uiDebugManager = null;
    protected Map attributes = new HashMap(3);
    private OverlayImageCache imageCache = new OverlayImageCache();

    public PDebugModelPresentation() {
        if (instance == null) {
            instance = this;
        }
    }

    public static PDebugModelPresentation getDefault() {
        if (instance == null) {
            instance = new PDebugModelPresentation();
        }
        return instance;
    }

    private UIDebugManager getUIDebugManager() {
        if (this.uiDebugManager == null) {
            this.uiDebugManager = PTPDebugUIPlugin.getUIDebugManager();
        }
        return this.uiDebugManager;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input != null) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
            return descriptor != null ? descriptor.getId() : "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IPBreakpoint) {
            IPBreakpoint pbk = (IPBreakpoint)element;
            IFile file = null;
            try {
                IFile[] files;
                String handle = pbk.getSourceHandle();
                Path path = new Path(handle);
                if (path.isValidPath(handle) && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path)).length > 0) {
                    file = files[0];
                }
            }
            catch (CoreException coreException) {}
            if (file == null) {
                file = (IFile)pbk.getMarker().getResource().getAdapter(IFile.class);
            }
            if (file != null) {
                return new FileEditorInput(file);
            }
        }
        if (element instanceof FileStorage || element instanceof LocalFileStorage) {
            return new ExternalEditorInput((IStorage)element);
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        PValueDetailProvider.getDefault().computeDetail(value, listener);
    }

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this.getAttributes().put(attribute, value);
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        if (baseImage != null) {
            ImageDescriptor[] overlays = new ImageDescriptor[4];
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(baseImage, overlays));
        }
        return null;
    }

    private Image getBaseImage(Object element) {
        IBreakpoint bp;
        if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof IPBreakpoint) {
            return this.getBreakpointImage((IPBreakpoint)bp);
        }
        if (element instanceof IPBreakpoint) {
            return this.getBreakpointImage((IPBreakpoint)element);
        }
        return super.getImage(element);
    }

    protected Image getBreakpointImage(IPBreakpoint breakpoint) {
        try {
            if (breakpoint instanceof IPLineBreakpoint) {
                return this.getLineBreakpointImage((IPLineBreakpoint)breakpoint);
            }
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        return null;
    }

    protected Image getLineBreakpointImage(IPLineBreakpoint breakpoint) throws CoreException {
        String job_id = breakpoint.getJobId();
        String cur_job_id = this.getUIDebugManager().getCurrentJobId();
        if (!job_id.equals("Global") && !job_id.equals(cur_job_id)) {
            return new Image(null, 1, 1);
        }
        String descriptor = null;
        IElementHandler setManager = this.getUIDebugManager().getElementHandler(job_id);
        if (setManager == null) {
            descriptor = breakpoint.isEnabled() ? "bpt_curr_set_enable.gif" : "bpt_curr_set_disable.gif";
        } else {
            String cur_set_id = this.getUIDebugManager().getCurrentSetId();
            String bpt_set_id = breakpoint.getSetId();
            descriptor = bpt_set_id.equals(cur_set_id) ? (breakpoint.isEnabled() ? "bpt_curr_set_enable.gif" : "bpt_curr_set_disable.gif") : (setManager.getSet(bpt_set_id).isContainSets(cur_set_id) ? (breakpoint.isEnabled() ? "bpt_multi_set_enable.gif" : "bpt_multi_set_disable.gif") : (breakpoint.isEnabled() ? "bpt_no_set_enable.gif" : "bpt_no_set_disable.gif"));
        }
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(PDebugImage.getImage(descriptor), this.computeBreakpointOverlays((IPBreakpoint)breakpoint)));
    }

    public String getText(Object element) {
        IEnableDisableTarget target;
        String bt = this.getBaseText(element);
        if (bt == null) {
            return null;
        }
        StringBuffer baseText = new StringBuffer(bt);
        if (element instanceof IPDebugElementStatus && !((IPDebugElementStatus)element).isOK()) {
            baseText.append(PDebugModelPresentation.getFormattedString(" <{0}>", ((IPDebugElementStatus)element).getMessage()));
        }
        if (element instanceof IAdaptable && (target = (IEnableDisableTarget)((IAdaptable)element).getAdapter(IEnableDisableTarget.class)) != null && !target.isEnabled()) {
            baseText.append(' ');
            baseText.append(PDebugUIMessages.getString("PTPDebugModelPresentation.disabled1"));
        }
        return baseText.toString();
    }

    protected String getWatchExpressionText(IWatchExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append('\"').append(expression.getExpressionText()).append('\"');
        if (expression.isPending()) {
            result.append(" = ").append(DUMMY_STACKFRAME_LABEL);
        } else {
            IValue value = expression.getValue();
            if (value instanceof IPValue) {
                String valueString;
                String typeName;
                IPType type = null;
                try {
                    type = ((IPValue)value).getType();
                }
                catch (DebugException debugException) {}
                if (type != null && this.isShowVariableTypeNames() && !this.isEmpty(typeName = this.getVariableTypeName(type))) {
                    result.insert(0, String.valueOf(typeName) + ' ');
                }
                if (expression.isEnabled() && (valueString = this.getValueText(value)).length() > 0) {
                    result.append(" = ").append(valueString);
                }
            }
        }
        if (!expression.isEnabled()) {
            result.append(' ');
            result.append(PDebugUIMessages.getString("PTPDebugModelPresentation.disabled1"));
        }
        return result.toString();
    }

    private String getBaseText(Object element) {
        StringBuffer label;
        boolean showQualified;
        block18: {
            showQualified = this.isShowQualifiedNames();
            label = new StringBuffer();
            if (element instanceof IPSignal) {
                label.append(this.getSignalText((IPSignal)element));
                return label.toString();
            }
            if (element instanceof IWatchExpression) {
                return this.getWatchExpressionText((IWatchExpression)element);
            }
            if (element instanceof IVariable) {
                label.append(this.getVariableText((IVariable)element));
                return label.toString();
            }
            if (element instanceof IValue) {
                label.append(this.getValueText((IValue)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (!(element instanceof IMarker)) break block18;
            IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
            if (breakpoint != null) {
                return this.getBreakpointText(breakpoint, showQualified);
            }
            return null;
        }
        try {
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element, showQualified);
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            } else if (element instanceof IThread) {
                label.append(this.getThreadText((IThread)element, showQualified));
            }
            if (label.length() > 0) {
                return label.toString();
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, PDebugUIMessages.getString("PTPDebugModelPresentation.terminated1"));
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, PDebugUIMessages.getString("PTPDebugModelPresentation.disconnected1"));
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException e) {
            PTPDebugUIPlugin.log(e);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        return null;
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.getAttributes().get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.getAttributes().get(DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    private Map getAttributes() {
        return this.attributes;
    }

    protected String getSignalText(IPSignal signal) {
        StringBuffer sb = new StringBuffer(PDebugUIMessages.getString("PTPDebugModelPresentation.signal"));
        try {
            String name = signal.getName();
            sb.append(" '").append(name).append('\'');
        }
        catch (DebugException debugException) {}
        return sb.toString();
    }

    private String getVariableTypeName(IPType type) {
        StringBuffer result = new StringBuffer();
        String typeName = type.getName();
        if (typeName != null) {
            typeName = typeName.trim();
        }
        if (typeName != null && typeName.length() > 0) {
            result.append(typeName);
            if (type.isArray()) {
                int[] dims = type.getArrayDimensions();
                int i = 0;
                while (i < dims.length) {
                    result.append('[');
                    result.append(dims[i]);
                    result.append(']');
                    ++i;
                }
            }
        }
        return result.toString();
    }

    protected String getVariableText(IVariable var) throws DebugException {
        StringBuffer label = new StringBuffer();
        if (var instanceof IPVariable) {
            String valueString;
            String name;
            String typeName;
            IPType type = null;
            try {
                type = ((IPVariable)var).getType();
            }
            catch (DebugException debugException) {}
            if (type != null && this.isShowVariableTypeNames() && (typeName = this.getVariableTypeName(type)) != null && typeName.length() > 0) {
                label.append(typeName).append(' ');
            }
            if ((name = var.getName()) != null) {
                label.append(name.trim());
            }
            if (!this.isEmpty(valueString = this.getValueText(var.getValue()))) {
                label.append(" = ");
                label.append(valueString);
            }
        }
        return label.toString();
    }

    protected String getValueText(IValue value) {
        StringBuffer label = new StringBuffer();
        if (value instanceof IPDebugElementStatus && !((IPDebugElementStatus)value).isOK()) {
            label.append(PDebugModelPresentation.getFormattedString(PDebugUIMessages.getString("PTPDebugModelPresentation.error1"), ((IPDebugElementStatus)value).getMessage()));
        } else if (value instanceof IPValue) {
            IPType type = null;
            try {
                type = ((IPValue)value).getType();
            }
            catch (DebugException debugException) {}
            try {
                String valueString = value.getValueString();
                if (valueString != null) {
                    valueString = valueString.trim();
                    if (type != null && type.isCharacter()) {
                        if (valueString.length() == 0) {
                            valueString = ".";
                        }
                        label.append(valueString);
                    } else if ((type == null || !type.isArray() && !type.isStructure()) && valueString.length() > 0) {
                        label.append(valueString);
                    }
                }
            }
            catch (DebugException debugException) {}
        }
        return label.toString();
    }

    private OverlayImageCache getImageCache() {
        return this.imageCache;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        if (breakpoint instanceof IPLineBreakpoint) {
            return this.getLineBreakpointText((IPLineBreakpoint)breakpoint, qualified);
        }
        return "";
    }

    protected String getLineBreakpointText(IPLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendSourceName((IPBreakpoint)breakpoint, label, qualified);
        this.appendLineNumber(breakpoint, label);
        this.appendBreakpointStatus((IPBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected StringBuffer appendSourceName(IPBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        Path path;
        String handle = breakpoint.getSourceHandle();
        if (!this.isEmpty(handle) && (path = new Path(handle)).isValidPath(handle)) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected StringBuffer appendLineNumber(IPLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(" ");
            label.append(MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.line1"), Integer.toString(lineNumber)));
        }
        return label;
    }

    protected StringBuffer appendBreakpointStatus(IPBreakpoint breakpoint, StringBuffer label) throws CoreException {
        label.append(" ");
        label.append("{");
        label.append(breakpoint.getJobName());
        label.append(":");
        label.append(breakpoint.getSetId());
        label.append("}");
        return label;
    }

    private ImageDescriptor[] computeBreakpointOverlays(IPBreakpoint breakpoint) {
        ImageDescriptor[] overlays = new ImageDescriptor[4];
        try {
            if (breakpoint.isGlobal()) {
                ImageDescriptor imageDescriptor = overlays[0] = breakpoint.isEnabled() ? PDebugImage.ID_IMG_DEBUG_OVER_BPT_GLOB_EN : PDebugImage.ID_IMG_DEBUG_OVER_BPT_GLOB_DI;
            }
            if (breakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? PDebugImage.ID_IMG_DEBUG_OVER_BPT_COND_EN : PDebugImage.ID_IMG_DEBUG_OVER_BPT_COND_DI;
            }
            if (breakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? PDebugImage.ID_IMG_DEBUG_OVER_BPT_INST_EN : PDebugImage.ID_IMG_DEBUG_OVER_BPT_INST_DI;
            }
            if (breakpoint instanceof IPAddressBreakpoint) {
                ImageDescriptor imageDescriptor = overlays[1] = breakpoint.isEnabled() ? PDebugImage.ID_IMG_DEBUG_OVER_BPT_ADDR_EN : PDebugImage.ID_IMG_DEBUG_OVER_BPT_ADDR_DI;
            }
            if (breakpoint instanceof IPFunctionBreakpoint) {
                overlays[3] = breakpoint.isEnabled() ? PDebugImage.ID_IMG_DEBUG_OVER_BPT_FUNC_EN : PDebugImage.ID_IMG_DEBUG_OVER_BPT_FUNC_DI;
            }
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        return overlays;
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        IPDebugTarget t = (IPDebugTarget)target.getAdapter(IPDebugTarget.class);
        if (t != null && !t.isPostMortem()) {
            PDebugElementState state = t.getState();
            if (state.equals(PDebugElementState.EXITED)) {
                Object info = t.getCurrentStateInfo();
                String label = PDebugUIMessages.getString("PTPDebugModelPresentation.target1");
                String reason = "";
                if (info != null && info instanceof IPCDISignalExitInfo) {
                    IPCDISignalExitInfo sigInfo = (IPCDISignalExitInfo)info;
                    reason = String.valueOf(' ') + MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.target2"), sigInfo.getName(), sigInfo.getDescription());
                } else if (info != null && info instanceof IPCDIExitInfo) {
                    reason = String.valueOf(' ') + MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.target3"), new Integer(((IPCDIExitInfo)info).getCode()));
                }
                return MessageFormat.format(label, target.getName(), reason);
            }
            if (state.equals(PDebugElementState.SUSPENDED)) {
                return MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.target4"), target.getName());
            }
        }
        return target.getName();
    }

    protected String getThreadText(IThread thread, boolean qualified) throws DebugException {
        IPDebugTarget target = (IPDebugTarget)thread.getDebugTarget().getAdapter(IPDebugTarget.class);
        if (target.isPostMortem()) {
            return PDebugModelPresentation.getFormattedString(PDebugUIMessages.getString("PTPDebugModelPresentation.thread"), thread.getName());
        }
        if (thread.isTerminated()) {
            return PDebugModelPresentation.getFormattedString(PDebugUIMessages.getString("PTPDebugModelPresentation.thread2"), thread.getName());
        }
        if (thread.isStepping()) {
            return PDebugModelPresentation.getFormattedString(PDebugUIMessages.getString("PTPDebugModelPresentation.thread3"), thread.getName());
        }
        if (!thread.isSuspended()) {
            return PDebugModelPresentation.getFormattedString(PDebugUIMessages.getString("PTPDebugModelPresentation.thread4"), thread.getName());
        }
        if (thread.isSuspended()) {
            String reason = "";
            IPDebugElement element = (IPDebugElement)thread.getAdapter(IPDebugElement.class);
            if (element != null) {
                Object info = element.getCurrentStateInfo();
                if (info != null && info instanceof IPCDISignalReceived) {
                    IPCDISignal signal = ((IPCDISignalReceived)info).getSignal();
                    reason = MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.thread5"), signal.getName(), signal.getDescription());
                } else if (info != null && info instanceof IPCDIWatchpointTrigger) {
                    reason = MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.thread6"), ((IPCDIWatchpointTrigger)info).getOldValue(), ((IPCDIWatchpointTrigger)info).getNewValue());
                } else if (info != null && info instanceof IPCDIWatchpointScope) {
                    reason = PDebugUIMessages.getString("PTPDebugModelPresentation.thread7");
                } else if (info != null && info instanceof IPCDIBreakpointHit) {
                    reason = PDebugUIMessages.getString("PTPDebugModelPresentation.thread8");
                } else if (info != null && info instanceof IPCDISharedLibraryEvent) {
                    reason = PDebugUIMessages.getString("PTPDebugModelPresentation.thread9");
                }
            }
            return MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.thread10"), thread.getName(), reason);
        }
        return MessageFormat.format(PDebugUIMessages.getString("PTPDebugModelPresentation.thread11"), thread.getName());
    }

    protected String getStackFrameText(IStackFrame f, boolean qualified) throws DebugException {
        if (f instanceof IPStackFrame) {
            IPStackFrame frame = (IPStackFrame)f;
            StringBuffer label = new StringBuffer();
            label.append(frame.getLevel());
            label.append(' ');
            String function = frame.getFunction();
            if (this.isEmpty(function)) {
                label.append(PDebugUIMessages.getString("PTPDebugModelPresentation.frame2"));
            } else if ((function = function.trim()).length() > 0) {
                Path path;
                label.append(function);
                label.append("() ");
                if (frame.getFile() != null && !(path = new Path(frame.getFile())).isEmpty()) {
                    label.append(PDebugUIMessages.getString("PTPDebugModelPresentation.frame1"));
                    label.append(' ');
                    label.append(qualified ? path.toOSString() : path.lastSegment());
                    label.append(':');
                    if (frame.getFrameLineNumber() != 0) {
                        label.append(frame.getFrameLineNumber());
                    }
                }
            }
            IAddress address = frame.getAddress();
            if (address != null) {
                label.append(' ');
                label.append(address.toHexAddressString());
            }
            return label.toString();
        }
        return f.getAdapter(IPDummyStackFrame.class) != null ? this.getDummyStackFrameLabel(f) : f.getName();
    }

    private String getDummyStackFrameLabel(IStackFrame stackFrame) {
        return DUMMY_STACKFRAME_LABEL;
    }

    public static String getFormattedString(String key, String arg) {
        return PDebugModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format(string, args);
    }

    public void dispose() {
        this.getImageCache().disposeAll();
        this.attributes.clear();
        super.dispose();
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame stackFrame) {
        try {
            PAnnotationManager.getDefault().addAnnotation(editorPart, stackFrame);
            return true;
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
            return false;
        }
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
    }
}

