/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IFileContextData;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class DefaultMacroContextInfo
implements IMacroContextInfo {
    private IBuildMacroSupplier[] fSuppliers;
    private int fType;
    private Object fData;

    public DefaultMacroContextInfo(int type, Object data) {
        this.fType = type;
        this.fData = data;
    }

    protected DefaultMacroContextInfo(int type, Object data, IBuildMacroSupplier[] suppliers) {
        this.fType = type;
        this.fData = data;
        this.fSuppliers = suppliers;
    }

    protected IBuildMacroSupplier[] getSuppliers(int type, Object data) {
        switch (type) {
            case 1: {
                if (!(data instanceof IFileContextData)) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fMbsMacroSupplier};
            }
            case 2: {
                if (!(data instanceof IOptionContextData)) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fMbsMacroSupplier};
            }
            case 8: {
                if (!(data instanceof ITool)) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fMbsMacroSupplier};
            }
            case 3: {
                if (!(data instanceof IConfiguration)) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fUserDefinedMacroSupplier, BuildMacroProvider.fExternalExtensionMacroSupplier, BuildMacroProvider.fEnvironmentMacroSupplier, BuildMacroProvider.fMbsMacroSupplier};
            }
            case 4: {
                if (!(data instanceof IManagedProject)) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fUserDefinedMacroSupplier, BuildMacroProvider.fExternalExtensionMacroSupplier, BuildMacroProvider.fEnvironmentMacroSupplier, BuildMacroProvider.fMbsMacroSupplier};
            }
            case 5: {
                if (!(data instanceof IWorkspace)) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fUserDefinedMacroSupplier, BuildMacroProvider.fEnvironmentMacroSupplier, BuildMacroProvider.fMbsMacroSupplier, BuildMacroProvider.fCdtPathEntryMacroSupplier, BuildMacroProvider.fEclipseVariablesMacroSupplier};
            }
            case 6: {
                if (data != null) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fMbsMacroSupplier};
            }
            case 7: {
                if (data != null) break;
                return new IBuildMacroSupplier[]{BuildMacroProvider.fEnvironmentMacroSupplier};
            }
        }
        return null;
    }

    public int getContextType() {
        return this.fType;
    }

    public Object getContextData() {
        return this.fData;
    }

    public IBuildMacroSupplier[] getSuppliers() {
        if (this.fSuppliers == null) {
            this.fSuppliers = this.getSuppliers(this.fType, this.fData);
        }
        return this.fSuppliers;
    }

    public IMacroContextInfo getNext() {
        switch (this.fType) {
            case 1: {
                IFileContextData fileContext;
                IOptionContextData optionContext;
                if (!(this.fData instanceof IFileContextData) || (optionContext = (fileContext = (IFileContextData)this.fData).getOptionContextData()) == null) break;
                return new DefaultMacroContextInfo(2, optionContext);
            }
            case 2: {
                if (!(this.fData instanceof IOptionContextData)) break;
                IOptionContextData optionContext = (IOptionContextData)this.fData;
                IHoldsOptions ho = OptionContextData.getHolder(optionContext);
                if (ho instanceof ITool) {
                    return new DefaultMacroContextInfo(8, ho);
                }
                if (ho instanceof IToolChain) {
                    return new DefaultMacroContextInfo(3, ((IToolChain)ho).getParent());
                }
                IBuildObject buildObj = optionContext.getParent();
                IConfiguration cfg = null;
                if (buildObj instanceof ITool) {
                    buildObj = ((ITool)buildObj).getParent();
                }
                if (buildObj instanceof IToolChain) {
                    cfg = ((IToolChain)buildObj).getParent();
                } else if (buildObj instanceof IResourceConfiguration) {
                    cfg = ((IResourceConfiguration)buildObj).getParent();
                } else if (buildObj instanceof IConfiguration) {
                    cfg = (IConfiguration)buildObj;
                }
                if (cfg == null) break;
                return new DefaultMacroContextInfo(3, cfg);
            }
            case 8: {
                if (!(this.fData instanceof ITool)) break;
                IBuildObject parent = ((ITool)this.fData).getParent();
                IConfiguration cfg = null;
                if (parent instanceof IToolChain) {
                    cfg = ((IToolChain)parent).getParent();
                } else if (parent instanceof IResourceConfiguration) {
                    cfg = ((IResourceConfiguration)parent).getParent();
                }
                if (cfg == null) break;
                return new DefaultMacroContextInfo(3, cfg);
            }
            case 3: {
                IConfiguration configuration;
                IManagedProject managedProject;
                if (!(this.fData instanceof IConfiguration) || (managedProject = (configuration = (IConfiguration)this.fData).getManagedProject()) == null) break;
                return new DefaultMacroContextInfo(4, managedProject);
            }
            case 4: {
                IWorkspace wsp;
                if (!(this.fData instanceof IManagedProject) || (wsp = ResourcesPlugin.getWorkspace()) == null) break;
                return new DefaultMacroContextInfo(5, wsp);
            }
            case 5: {
                if (!(this.fData instanceof IWorkspace)) break;
                return new DefaultMacroContextInfo(6, null);
            }
            case 6: {
                if (this.fData != null) break;
                return new DefaultMacroContextInfo(7, null);
            }
            case 7: {
                if (this.fData != null) break;
                return null;
            }
        }
        return null;
    }
}

