/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDebugDestroyedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIErrorEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIExitedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.external.core.DebugCommandQueue;
import org.eclipse.ptp.debug.external.core.EventThread;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointCreatedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.DebuggerDestroyedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.EndSteppingRangeEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.ErrorEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorExitedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorResumedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorSignaledEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.SuspendEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.LineLocation;
import org.eclipse.ptp.debug.external.core.commands.StartDebuggerCommand;
import org.eclipse.ptp.debug.external.core.commands.StopDebuggerCommand;
import org.eclipse.ptp.debug.external.core.commands.TerminateCommand;

public abstract class AbstractDebugger
extends Observable
implements IAbstractDebugger {
    protected EventThread eventThread = null;
    protected IPCDISession session = null;
    protected IPProcess[] procs;
    protected boolean isExited = false;
    protected IPJob job = null;
    protected DebugCommandQueue commandQueue = null;

    public IPCDISession createDebuggerSession(IPLaunch launch, IBinaryParser.IBinaryObject exe, int timeout, IProgressMonitor monitor) throws CoreException {
        IPJob job = launch.getPJob();
        this.session = new Session(this, job, launch, exe);
        this.initialize(job, timeout, monitor);
        this.job = job;
        return this.session;
    }

    public IDebugCommand getCurrentCommand() {
        return this.commandQueue.getCurrentCommand();
    }

    public IDebugCommand getInterruptCommand() {
        return this.commandQueue.getInterruptCommand();
    }

    public void postInterruptCommand(IDebugCommand command) {
        this.commandQueue.setInterruptCommand(command);
    }

    public void postCommand(IDebugCommand command) {
        if (!this.isExited) {
            this.commandQueue.addCommand(command);
        }
    }

    public void completeCommand(BitList tasks, Object result) {
        this.commandQueue.setCommandReturn(tasks, result);
    }

    public final void initialize(IPJob job, int timeout, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Connecting to proxy server...");
        this.connection(monitor);
        monitor.worked(5);
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        monitor.subTask("Starting debugger...");
        job.setAttribute("terminated", (Object)new BitList(job.totalProcesses()));
        job.setAttribute("suspended", (Object)new BitList(job.totalProcesses()));
        this.commandQueue = new DebugCommandQueue(this);
        this.isExited = false;
        this.eventThread = new EventThread(this);
        this.procs = job.getSortedProcesses();
        monitor.worked(10);
        StartDebuggerCommand command = new StartDebuggerCommand(this.session.createBitList(), job);
        this.postCommand(command);
        monitor.worked(10);
        try {
            command.waitForReturn();
        }
        catch (PCDIException e) {
            if (this.session != null) {
                this.setJobFinished(command.getTasks(), "error");
            }
            this.exit();
            throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public final void exit() throws CoreException {
        if (!this.isExited) {
            if (this.session != null && !this.isJobFinished()) {
                this.setJobFinished(this.session.createBitList(), "exited");
            }
            try {
                this.stopDebugger();
            }
            finally {
                this.isExited = true;
                this.deleteObservers();
                this.eventThread.cancelJob();
                this.commandQueue.setTerminated();
                this.disconnection(null);
            }
        }
        this.disconnection(null);
    }

    public final IPCDISession getSession() {
        return this.session;
    }

    public final void addDebuggerObserver(Observer obs) {
        this.addObserver(obs);
    }

    public final void deleteDebuggerObserver(Observer obs) {
        this.deleteObserver(obs);
    }

    public final void deleteAllObservers() {
        this.deleteObservers();
    }

    public final synchronized void fireEvents(IPCDIEvent[] events) {
        if (events != null && events.length > 0) {
            int i = 0;
            while (i < events.length) {
                this.fireEvent(events[i]);
                ++i;
            }
        }
    }

    public final synchronized void fireEvent(IPCDIEvent event) {
        if (event != null) {
            BitList tasks = event.getAllProcesses();
            PDebugUtils.println((String)("***** Debugger event: " + event));
            if (event instanceof IPCDIDebugDestroyedEvent) {
                this.commandQueue.setTerminated();
            } else if (event instanceof IPCDIExitedEvent) {
                this.setJobFinished(tasks, ((IPCDIExitedEvent)event).getExitStatus() > -1 ? "exited" : "exited-signalled");
                if (this.isJobFinished()) {
                    this.postStopDebugger();
                }
            } else if (event instanceof IPCDIResumedEvent) {
                this.setSuspendTasks(false, tasks);
                this.setProcessStatus(tasks.toArray(), "running");
            } else if (event instanceof IPCDIErrorEvent) {
                this.handleException(tasks, ((IPCDIErrorEvent)event).getErrorCode());
            } else if (event instanceof IPCDISuspendedEvent) {
                this.setSuspendTasks(true, tasks);
                this.setProcessStatus(tasks.toArray(), "stopped");
            }
            this.eventThread.fireDebugEvent(event);
        }
    }

    protected void handleException(BitList tasks, int err_code) {
        switch (err_code) {
            case 2: {
                this.setJobFinished(tasks, "error");
                this.postStopDebugger();
                break;
            }
            case 1: {
                if (this.session.getJob().isAllStop()) break;
                this.setJobFinished(tasks, "error");
                this.postCommand(new TerminateCommand(tasks));
            }
        }
    }

    private void postStopDebugger() {
        this.commandQueue.cleanup(true);
        this.postCommand(new StopDebuggerCommand(this.getSession().createBitList()));
        this.commandQueue.setStopAddCommand(true);
    }

    public final void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public final boolean isExited() {
        return this.isExited;
    }

    protected synchronized void setJobFinished(BitList tasks, String status) {
        if (tasks == null || tasks.isEmpty()) {
            tasks = this.session.createBitList();
        }
        this.setSuspendTasks(false, tasks);
        this.setTerminateTasks(true, tasks);
        this.setProcessStatus(tasks.toArray(), status);
        this.session.unregisterTargets(tasks.copy(), true);
    }

    protected synchronized void setTerminateTasks(boolean isAdd, BitList tasks) {
        BitList terminatedTasks = this.getTerminatedProc();
        if (isAdd) {
            terminatedTasks = this.addTasks(terminatedTasks, tasks);
        } else {
            this.removeTasks(terminatedTasks, tasks);
        }
    }

    protected synchronized void setSuspendTasks(boolean isAdd, BitList tasks) {
        BitList suspendedTasks = this.getSuspendedProc();
        if (isAdd) {
            suspendedTasks = this.addTasks(suspendedTasks, tasks);
        } else {
            this.removeTasks(suspendedTasks, tasks);
        }
    }

    protected void setProcessStatus(int[] tasks, String state) {
        int i = 0;
        while (i < tasks.length) {
            this.getProcess(tasks[i]).setStatus(state);
            ++i;
        }
    }

    public synchronized BitList getSuspendedProc() {
        return (BitList)this.job.getAttribute("suspended");
    }

    public synchronized BitList getTerminatedProc() {
        return (BitList)this.job.getAttribute("terminated");
    }

    public void handleStopDebuggerEvent() {
        this.fireEvent(new DebuggerDestroyedEvent(this.getSession()));
    }

    public void handleBreakpointCreatedEvent(BitList tasks, IPCDIBreakpoint cdiBpt) {
        this.fireEvent(new BreakpointCreatedEvent(this.getSession(), tasks, cdiBpt));
    }

    public void handleBreakpointHitEvent(BitList tasks, int bpid, int thread_id, String[] varchanges) {
        IPCDIBreakpoint bpt = ((Session)this.getSession()).getBreakpointManager().findCDIBreakpoint(bpid);
        if (bpt != null) {
            this.fireEvent(new BreakpointHitEvent(this.getSession(), tasks, bpt, thread_id, varchanges));
        }
    }

    public void handleSuspendEvent(BitList tasks, IPCDILocator locator, int thread_id, String[] varchanges) {
        this.fireEvent(new SuspendEvent(this.getSession(), tasks, locator, thread_id, varchanges));
    }

    public void handleEndSteppingEvent(BitList tasks, int lineNumber, String filename, int thread_id, String[] varchanges) {
        LineLocation loc = new LineLocation(filename, lineNumber);
        this.fireEvent(new EndSteppingRangeEvent(this.getSession(), tasks, loc, thread_id, varchanges));
    }

    public void handleProcessSignaledEvent(BitList tasks, IPCDILocator locator, int thread_id, String[] varchanges) {
        this.fireEvent(new InferiorSignaledEvent(this.getSession(), tasks, locator, thread_id, varchanges));
    }

    public void handleProcessResumedEvent(BitList tasks, int type) {
        this.fireEvent(new InferiorResumedEvent(this.getSession(), tasks, type));
    }

    public void handleProcessTerminatedEvent(BitList tasks, int exitStatus) {
        this.fireEvent(new InferiorExitedEvent(this.getSession(), tasks, exitStatus));
    }

    public void handleProcessTerminatedEvent(BitList tasks, String signalName, String signalMeaning) {
        this.fireEvent(new InferiorExitedEvent(this.getSession(), tasks, signalName, signalMeaning));
    }

    public void handleErrorEvent(BitList tasks, String errMsg, int errCode) {
        PDebugUtils.println((String)("----- debugger error: " + errMsg + " on Tasks: " + AbstractDebugger.showBitList(tasks) + " ------------"));
        if (tasks == null || tasks.isEmpty() || errCode == 2) {
            tasks = this.session.createBitList();
        }
        this.fireEvent(new ErrorEvent(this.getSession(), tasks, errMsg, errCode));
    }

    public IPProcess getProcess(int number) {
        return this.procs[number];
    }

    public IPProcess[] getProcesses(BitList tasks) {
        int[] taskArray = tasks.toArray();
        IPProcess[] processes = new IPProcess[taskArray.length];
        int i = 0;
        while (i < taskArray.length) {
            processes[i] = this.getProcess(taskArray[i]);
            ++i;
        }
        return processes;
    }

    public synchronized boolean isSuspended(BitList tasks) {
        this.removeTasks(tasks, this.getSuspendedProc());
        return tasks.isEmpty();
    }

    public synchronized boolean isTerminated(BitList tasks) {
        this.removeTasks(tasks, this.getTerminatedProc());
        return tasks.isEmpty();
    }

    public synchronized BitList filterRunningTasks(BitList tasks) {
        this.removeTasks(tasks, this.getTerminatedProc());
        BitList suspendedTasks = this.getSuspendedProc();
        if (suspendedTasks.cardinality() > 0) {
            tasks.and(suspendedTasks);
        }
        return tasks;
    }

    public synchronized BitList filterSuspendTasks(BitList tasks) {
        this.removeTasks(tasks, this.getTerminatedProc());
        this.removeTasks(tasks, this.getSuspendedProc());
        return tasks;
    }

    public synchronized BitList filterTerminateTasks(BitList tasks) {
        this.removeTasks(tasks, this.getTerminatedProc());
        return tasks;
    }

    public synchronized boolean isJobFinished() {
        return this.getTerminatedProc().cardinality() == this.job.totalProcesses();
    }

    private synchronized BitList addTasks(BitList curTasks, BitList newTasks) {
        if (curTasks.size() < newTasks.size()) {
            newTasks.or(curTasks);
            return newTasks.copy();
        }
        curTasks.or(newTasks);
        return curTasks;
    }

    private synchronized void removeTasks(BitList curTasks, BitList newTasks) {
        curTasks.andNot(newTasks);
    }

    public static String showBitList(BitList tasks) {
        if (tasks == null) {
            return "";
        }
        int[] array = tasks.toArray();
        if (array.length == 0) {
            return "";
        }
        String msg = "";
        int preTask = array[0];
        msg = String.valueOf(msg) + preTask;
        boolean isContinue = false;
        int i = 1;
        while (i < array.length) {
            if (preTask == array[i] - 1) {
                preTask = array[i];
                isContinue = true;
                if (i == array.length - 1) {
                    msg = String.valueOf(msg) + "-" + array[i];
                    break;
                }
            } else {
                if (isContinue) {
                    msg = String.valueOf(msg) + "-" + preTask;
                }
                msg = String.valueOf(msg) + "," + array[i];
                isContinue = false;
                preTask = array[i];
            }
            ++i;
        }
        return msg;
    }
}

