/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIDebugProcess;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIDebugProcessSet;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SessionObject;

public class DebugProcessSet
extends SessionObject
implements IPCDIDebugProcessSet {
    private static int tempId = 0;
    private final String PREFIX = "TempSet_";
    protected String setName;
    protected BitList processList = null;

    public DebugProcessSet(DebugProcessSet set) {
        super((Session)set.getSession());
        this.processList = set.toBitList().copy();
        this.setName = "TempSet_" + tempId++;
    }

    public DebugProcessSet(IPCDISession s) {
        super((Session)s);
        this.processList = new BitList(s.getTotalProcesses());
        this.setName = "TempSet_" + tempId++;
    }

    public DebugProcessSet(IPCDISession s, BitList list) {
        super((Session)s);
        this.processList = list;
        this.setName = "TempSet_" + tempId++;
    }

    public DebugProcessSet(IPCDISession s, int proc) {
        this(s, new int[]{proc});
    }

    public DebugProcessSet(IPCDISession s, int[] procs) {
        super((Session)s);
        this.processList = new BitList(s.getTotalProcesses());
        this.processList.set(procs);
        this.setName = "TempSet_" + tempId++;
    }

    public IPCDIDebugProcess[] getProcesses() {
        int[] list = this.toIntArray();
        IPCDIDebugProcess[] retVal = new IPCDIDebugProcess[list.length];
        int i = 0;
        while (i < list.length) {
            retVal[i] = this.getProcess(list[i]);
            ++i;
        }
        return retVal;
    }

    public IPCDIDebugProcess getProcess(int number) {
        return null;
    }

    public int getSize() {
        return this.processList.cardinality();
    }

    public int[] toIntArray() {
        return this.processList.toArray();
    }

    public String getName() {
        return this.setName;
    }

    public BitList toBitList() {
        return this.processList;
    }

    public void addProcess(int proc) {
        this.processList.set(proc);
    }

    public void addProcess(int[] proc) {
        this.processList.set(proc);
    }

    public void removeProcess(int proc) {
        this.processList.clear(proc);
    }

    public void removeProcess(int[] proc) {
        this.processList.clear(proc);
    }
}

