/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.ExtFormat;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIMemoryBlock;
import org.eclipse.ptp.debug.external.core.cdi.MemoryManager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.model.DataReadMemoryInfo;
import org.eclipse.ptp.debug.external.core.cdi.model.Memory;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.commands.DataWriteMemoryCommand;

public class MemoryBlock
extends PObject
implements IPCDIMemoryBlock {
    String expression;
    boolean frozen;
    boolean dirty;
    private DataReadMemoryInfo mem;
    private int fWordSize;
    private BigInteger cStartAddress;
    private byte[] cBytes;
    private int[] badOffsets;
    private boolean fIsLittleEndian;

    public MemoryBlock(Target target, String exp, int wordSize, boolean isLittle, DataReadMemoryInfo info) {
        super(target);
        this.expression = exp;
        this.fWordSize = wordSize;
        this.frozen = true;
        this.fIsLittleEndian = isLittle;
        this.setDataReadMemoryInfo(info);
    }

    public String getExpression() {
        return this.expression;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public void setDataReadMemoryInfo(DataReadMemoryInfo m) {
        this.cStartAddress = ExtFormat.getBigInteger((String)m.getAddress());
        this.cBytes = this.getBytes(m);
        this.mem = m;
    }

    public DataReadMemoryInfo getDataReadMemoryInfo() {
        return this.mem;
    }

    public boolean contains(BigInteger[] adds) {
        int i = 0;
        while (i < adds.length) {
            if (this.contains(adds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(BigInteger addr) {
        BigInteger start = this.getStartAddress();
        long length = this.getLength();
        return start.compareTo(addr) <= 0 && addr.compareTo(start.add(BigInteger.valueOf(length))) <= 0;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean d) {
        this.dirty = d;
    }

    private byte[] getBytes(DataReadMemoryInfo m) {
        byte[] bytes = new byte[]{};
        if (m == null) {
            return bytes;
        }
        Memory[] miMem = m.getMemories();
        int i = 0;
        while (i < miMem.length) {
            long[] data = miMem[i].getData();
            if (data != null && data.length > 0) {
                int j = 0;
                while (j < data.length) {
                    byte[] bs = this.longToBytes(data[j]);
                    int blen = bytes.length;
                    byte[] newBytes = new byte[blen + bs.length];
                    System.arraycopy(bytes, 0, newBytes, 0, blen);
                    System.arraycopy(bs, 0, newBytes, blen, bs.length);
                    bytes = newBytes;
                    ++j;
                }
            }
            ++i;
        }
        return bytes;
    }

    private int[] getBadOffsets(DataReadMemoryInfo m) {
        int[] offsets = new int[]{};
        if (m == null) {
            return offsets;
        }
        Memory[] miMem = m.getMemories();
        int i = 0;
        while (i < miMem.length) {
            int[] data = miMem[i].getBadOffsets();
            if (data.length > 0) {
                int olen = offsets.length;
                int[] newOffsets = new int[olen + data.length];
                System.arraycopy(offsets, 0, newOffsets, 0, olen);
                System.arraycopy(data, 0, newOffsets, olen, data.length);
                offsets = newOffsets;
            }
            ++i;
        }
        return offsets;
    }

    public byte[] getBytes() throws PCDIException {
        return this.cBytes;
    }

    public void refresh() throws PCDIException {
        Target target = (Target)this.getTarget();
        MemoryManager mgr = ((Session)target.getSession()).getMemoryManager();
        this.setDirty(true);
        BigInteger[] addresses = mgr.update(this, null);
        if (addresses.length > 0) {
            IPCDIMemoryBlock[] blocks = mgr.getMemoryBlocks(target);
            int i = 0;
            while (i < blocks.length) {
                MemoryBlock block = (MemoryBlock)blocks[i];
                if (!block.equals(this) && block.contains(addresses)) {
                    block.setDirty(true);
                    mgr.update(block, null);
                }
                ++i;
            }
        }
    }

    public long getLength() {
        try {
            return this.getBytes().length;
        }
        catch (PCDIException pCDIException) {
            return this.mem.getTotalBytes();
        }
    }

    public BigInteger getStartAddress() {
        return this.cStartAddress;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(long offset, byte[] bytes) throws PCDIException {
        if (offset >= this.getLength() || offset + (long)bytes.length > this.getLength()) {
            throw new PCDIException("No bad offset found");
        }
        Target target = (Target)this.getTarget();
        int i = 0;
        while (i < bytes.length) {
            long l = new Byte(bytes[i]).longValue() & 0xFFL;
            String value = "0x" + Long.toHexString(l);
            PDebugUtils.println((String)"----------- DataWriteMemoryCommand is called --------------");
            DataWriteMemoryCommand command = new DataWriteMemoryCommand(target.getTask(), offset + (long)i, this.expression, 0, 1, value);
            target.getDebugger().postCommand((IDebugCommand)command);
            if (command.getDataWriteMemoryInfo() == null) {
                throw new PCDIException("No response");
            }
            ++i;
        }
        this.refresh();
    }

    public synchronized byte getFlags(int offset) {
        if (offset < 0 || (long)offset >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.badOffsets == null) {
            this.badOffsets = this.getBadOffsets(this.mem);
        }
        if (this.badOffsets != null) {
            int i = 0;
            while (i < this.badOffsets.length) {
                if (this.badOffsets[i] == offset) {
                    return 0;
                }
                ++i;
            }
        }
        return 2;
    }

    private byte[] longToBytes(long v) {
        int count = 1;
        long value = v;
        count = 1;
        while ((value /= 256L) > 0L) {
            ++count;
        }
        if (this.fWordSize != count) {
            this.fWordSize = count;
        }
        byte[] bytes = new byte[count];
        if (this.fIsLittleEndian) {
            int i = count - 1;
            while (i >= 0) {
                int shift = i * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                --i;
            }
        } else {
            int i = 0;
            while (i < count) {
                int shift = (count - i - 1) * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                ++i;
            }
        }
        return bytes;
    }
}

