/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public abstract class AbstractBreakpointCommand
extends AbstractDebugCommand {
    IPCDIBreakpoint cdiBpt;
    boolean ignoreCheck = false;

    public AbstractBreakpointCommand(BitList tasks, IPCDIBreakpoint cdiBpt, boolean ignoreCheck) {
        super(tasks, false, true, true);
        this.cdiBpt = cdiBpt;
        this.ignoreCheck = ignoreCheck;
    }

    public IPCDIBreakpoint getPCDIBreakpoint() throws PCDIException {
        Object res = this.getResultValue();
        if (res instanceof IPCDIBreakpoint) {
            return (IPCDIBreakpoint)res;
        }
        throw new PCDIException("Cannot get breakpoint");
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        if (this.ignoreCheck) {
            this.exec(debugger);
        } else {
            BitList susTasks = this.suspendRunningTasks(debugger);
            this.exec(debugger);
            if (!susTasks.isEmpty()) {
                this.waitForReturn();
                this.resumeSuspendedTasks(debugger, susTasks);
            }
        }
    }
}

