/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.HaltCommand;

public abstract class AbstractDebugCommand
implements IDebugCommand {
    protected final Object lock = new Object();
    protected BitList tasks = null;
    protected BitList check_tasks = null;
    protected Object result = null;
    protected boolean waitForReturn = false;
    protected boolean interrupt = false;
    protected boolean flush = false;
    protected boolean cancelled = false;
    protected long timeout = 20000L;
    protected boolean waitInQueue = false;
    protected boolean waitAgain = false;
    protected boolean blocked = false;
    protected boolean command_finish = false;
    protected int priority = 2;

    public AbstractDebugCommand(BitList tasks) {
        this(tasks, false, true);
    }

    public AbstractDebugCommand(BitList tasks, boolean interrupt, boolean waitForReturn) {
        this(tasks, interrupt, waitForReturn, true);
    }

    public AbstractDebugCommand(BitList tasks, boolean interrupt, boolean waitForReturn, boolean waitInQueue) {
        if (tasks == null) {
            throw new IllegalArgumentException("Tasks cannot be null");
        }
        this.tasks = tasks;
        this.interrupt = interrupt;
        this.waitForReturn = waitForReturn;
        this.waitInQueue = waitInQueue;
        this.presetTimeout(PTPDebugCorePlugin.getDefault().getCommandTimeout());
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isWaitInQueue() {
        return this.waitInQueue;
    }

    public boolean canInterrupt() {
        return this.interrupt;
    }

    public BitList getTasks() {
        return this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaitForReturn() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitForReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getReturn() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkReturn() throws PCDIException {
        Object object = this.lock;
        synchronized (object) {
            block12: {
                Object result = this.getReturn();
                if (result == null) {
                    if (this.check_tasks != null && !this.check_tasks.isEmpty()) {
                        throw new PCDIException("Incomplete - Command " + this.getCommandName());
                    }
                    throw new PCDIException("Time out - Command " + this.getCommandName(), 0);
                }
                if (this.isBlocked()) {
                    throw new PCDIException("Time out - Command " + this.getCommandName(), 0);
                }
                if (result.equals("Incomplete")) {
                    throw new PCDIException("Incomplete - Command " + this.getCommandName());
                }
                if (result.equals("Nothing")) {
                    throw new PCDIException("Unknown error - Command " + this.getCommandName());
                }
                if (result instanceof PCDIException) {
                    throw (PCDIException)((Object)this.getReturn());
                }
                if (result.equals("Error")) {
                    throw new PCDIException("Tasks do not match with <" + this.getCommandName() + "> command.");
                }
                if (result.equals("Cancel")) {
                    throw new PCDIException("Cancelled - command " + this.getCommandName());
                }
                if (!result.equals("Flush")) break block12;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBlocked() {
        Object object = this.lock;
        synchronized (object) {
            return this.blocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock() {
        Object object = this.lock;
        synchronized (object) {
            this.waitAgain = false;
            this.blocked = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockAgain() {
        Object object = this.lock;
        synchronized (object) {
            this.waitAgain = true;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWait(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            do {
                this.waitAgain = false;
                this.blocked = true;
                this.lock.wait(timeout);
            } while (this.waitAgain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForReturn() throws PCDIException {
        Object object = this.lock;
        synchronized (object) {
            return this.waitForReturn(this.timeout);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForReturn(long timeout) throws PCDIException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isWaitForReturn() || this.command_finish) {
                return true;
            }
            try {
                this.doWait(timeout);
            }
            catch (InterruptedException e) {
                throw new PCDIException((Throwable)e);
            }
            try {
                boolean bl = this.checkReturn();
                return bl;
            }
            finally {
                this.command_finish = true;
            }
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFisinhed() {
        return this.command_finish;
    }

    protected boolean isCanncelled() {
        return this.cancelled;
    }

    protected boolean isFlush() {
        return this.flush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancelWaiting() {
        Object object = this.lock;
        synchronized (object) {
            this.command_finish = true;
            this.cancelled = true;
            this.setReturn("Cancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFlush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getReturn() == null) {
                this.command_finish = true;
                this.flush = true;
                this.setReturn("Flush");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCheckTasks() {
        Object object = this.lock;
        synchronized (object) {
            if (this.check_tasks == null) {
                this.check_tasks = this.tasks.copy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object result) {
        Object object = this.lock;
        synchronized (object) {
            this.result = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturn(Object result) {
        Object object = this.lock;
        synchronized (object) {
            this.setCheckTasks();
            this.setResult(result);
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturn(BitList return_tasks, Object result) {
        Object object = this.lock;
        synchronized (object) {
            this.setCheckTasks();
            if (return_tasks != null) {
                this.check_tasks.andNot(return_tasks);
                if (this.check_tasks.isEmpty()) {
                    this.setResult(result);
                    this.releaseLock();
                } else {
                    this.lockAgain();
                }
            } else {
                this.setReturn("Incomplete");
            }
        }
    }

    public int compareTo(Object obj) {
        if (obj instanceof IDebugCommand) {
            if (!this.getCommandName().equals(((IDebugCommand)obj).getCommandName())) {
                return -1;
            }
            BitList cpyTasks = this.getTasks().copy();
            cpyTasks.andNot(((IDebugCommand)obj).getTasks());
            return cpyTasks.isEmpty() ? 0 : -1;
        }
        return -1;
    }

    public Object getResultValue() throws PCDIException {
        if (this.getReturn() == null) {
            this.waitForReturn();
        }
        if (this.getReturn() instanceof PCDIException) {
            throw (PCDIException)((Object)this.getReturn());
        }
        return this.getReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitSuspendExecCommand(IAbstractDebugger debugger) throws PCDIException {
        Object object = this.lock;
        synchronized (object) {
            if (!debugger.isSuspended(this.tasks.copy())) {
                try {
                    this.wait(2000L);
                    if (!debugger.isSuspended(this.tasks.copy())) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException e) {
                    throw new PCDIException((Throwable)e);
                }
            }
            if (this.command_finish || !debugger.isSuspended(this.tasks.copy())) {
                PDebugUtils.println((String)"************************************ WAIT SUSPEND FAILURE");
                this.doFlush();
            } else {
                this.exec(debugger);
            }
        }
    }

    protected void checkBeforeExecCommand(IAbstractDebugger debugger) throws PCDIException {
        if (debugger.isSuspended(this.tasks.copy())) {
            this.exec(debugger);
        } else {
            this.doFlush();
        }
    }

    protected BitList suspendRunningTasks(IAbstractDebugger debugger) throws PCDIException {
        BitList tmpTasks = this.tasks.copy();
        debugger.filterSuspendTasks(tmpTasks);
        if (!tmpTasks.isEmpty()) {
            HaltCommand cmd = new HaltCommand(tmpTasks, true);
            debugger.postInterruptCommand((IDebugCommand)cmd);
            try {
                cmd.execCommand(debugger);
            }
            finally {
                debugger.postInterruptCommand(null);
            }
        }
        return tmpTasks;
    }

    protected void resumeSuspendedTasks(IAbstractDebugger debugger, BitList suspendedTasks) throws PCDIException {
        debugger.go(suspendedTasks);
    }

    public synchronized void execCommand(IAbstractDebugger debugger) throws PCDIException {
        this.preExecCommand(debugger);
        this.waitForReturn();
    }

    protected void presetTimeout(int timeout) {
        int size = this.tasks.cardinality();
        this.setTimeout(timeout * (size > 0 ? size : 1));
    }

    protected abstract void preExecCommand(IAbstractDebugger var1) throws PCDIException;

    protected abstract void exec(IAbstractDebugger var1) throws PCDIException;
}

