/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration2;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.debug.core.DebugException;

public class CLocalVariable
extends CVariable {
    public CLocalVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject, String errorMessage) {
        super(parent, cdiVariableObject, errorMessage);
    }

    public CLocalVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject) {
        super(parent, cdiVariableObject);
    }

    protected void createOriginal(ICDIVariableDescriptor vo) {
        if (vo != null) {
            this.setName(vo.getName());
            this.setOriginal(new InternalVariable(this, vo));
        }
    }

    private class InternalVariable
    implements CVariable.IInternalVariable {
        private CVariable fVariable;
        private ICDIVariableDescriptor fCDIVariableObject;
        private ICDIVariable fCDIVariable;
        private CType fType;
        private String fQualifiedName;
        private ICValue fValue = CValueFactory.NULL_VALUE;
        private boolean fChanged = false;

        InternalVariable(CVariable var, ICDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setCDIVariableObject(varObject);
            this.setCDIVariable(varObject instanceof ICDIVariable ? (ICDIVariable)varObject : null);
        }

        public CVariable.IInternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (CDIException e) {
                CLocalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        public CVariable.IInternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (CDIException e) {
                CLocalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        private synchronized ICDIVariable getCDIVariable() throws DebugException {
            if (this.fCDIVariable == null) {
                try {
                    this.fCDIVariable = ((CStackFrame)CLocalVariable.this.getStackFrame()).getCDIStackFrame().createLocalVariable((ICDILocalVariableDescriptor)this.getCDIVariableObject());
                }
                catch (CDIException e) {
                    CLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fCDIVariable;
        }

        private void setCDIVariable(ICDIVariable variable) {
            this.fCDIVariable = variable;
        }

        private ICDIVariableDescriptor getCDIVariableObject() {
            if (this.fCDIVariable != null) {
                return this.fCDIVariable;
            }
            return this.fCDIVariableObject;
        }

        private void setCDIVariableObject(ICDIVariableDescriptor variableObject) {
            this.fCDIVariableObject = variableObject;
        }

        public String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fCDIVariableObject != null ? this.fCDIVariableObject.getQualifiedName() : null;
                }
                catch (CDIException e) {
                    CLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CType getType() throws DebugException {
            ICDIVariableDescriptor varObject;
            if (this.fType == null && (varObject = this.getCDIVariableObject()) != null) {
                InternalVariable internalVariable = this;
                synchronized (internalVariable) {
                    if (this.fType == null) {
                        try {
                            this.fType = new CType(varObject.getType());
                        }
                        catch (CDIException e) {
                            CLocalVariable.requestFailed(e.getMessage(), null);
                        }
                    }
                }
            }
            return this.fType;
        }

        private synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fCDIVariable != null) {
                    this.fCDIVariable.dispose();
                }
            }
            catch (CDIException e) {
                CLocalVariable.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setCDIVariable(null);
            if (this.fType != null) {
                this.fType.dispose();
            }
            this.fType = null;
        }

        public void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        public boolean isSameVariable(ICDIVariable cdiVar) {
            return this.fCDIVariable != null ? this.fCDIVariable.equals(cdiVar) : false;
        }

        public int sizeof() {
            if (this.getCDIVariableObject() != null) {
                try {
                    return this.getCDIVariableObject().sizeof();
                }
                catch (CDIException cDIException) {}
            }
            return 0;
        }

        public boolean isArgument() {
            return this.getCDIVariableObject() instanceof ICDIArgumentDescriptor;
        }

        public void setValue(String expression) throws DebugException {
            ICDIVariable cdiVariable = null;
            try {
                cdiVariable = this.getCDIVariable();
                if (cdiVariable != null) {
                    cdiVariable.setValue(expression);
                } else {
                    CLocalVariable.requestFailed(CoreModelMessages.getString("CModificationVariable.0"), null);
                }
            }
            catch (CDIException e) {
                CLocalVariable.targetRequestFailed(e.getMessage(), null);
            }
        }

        public synchronized ICValue getValue() throws DebugException {
            ICDIVariable var;
            if (this.fValue.equals(CValueFactory.NULL_VALUE) && (var = this.getCDIVariable()) != null) {
                try {
                    ICDIValue cdiValue = var.getValue();
                    if (cdiValue != null) {
                        ICDIType cdiType = cdiValue.getType();
                        if (cdiValue instanceof ICDIArrayValue && cdiType != null) {
                            int[] dims;
                            CType type = new CType(cdiType);
                            if (type.isArray() && (dims = type.getArrayDimensions()).length > 0 && dims[0] > 0) {
                                this.fValue = CValueFactory.createIndexedValue(this.getVariable(), (ICDIArrayValue)cdiValue, 0, dims[0]);
                            }
                        } else {
                            this.fValue = CValueFactory.createValue(this.getVariable(), cdiValue);
                        }
                    }
                    if (CLocalVariable.this.getCDITarget().getConfiguration() instanceof ICDITargetConfiguration2 && ((ICDITargetConfiguration2)CLocalVariable.this.getCDITarget().getConfiguration()).supportsRuntimeTypeIdentification()) {
                        this.fType = null;
                    }
                }
                catch (CDIException e) {
                    CLocalVariable.requestFailed(e.getMessage(), e);
                }
            }
            return this.fValue;
        }

        public void invalidateValue() {
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).dispose();
                this.fValue = CValueFactory.NULL_VALUE;
            }
        }

        public boolean isChanged() {
            return this.fChanged;
        }

        public synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        public synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).preserve();
            }
        }

        CVariable getVariable() {
            return this.fVariable;
        }

        private void setVariable(CVariable variable) {
            this.fVariable = variable;
        }

        public void resetValue() {
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).reset();
            }
        }

        public boolean isEditable() throws DebugException {
            ICDIVariable var = this.getCDIVariable();
            if (var != null) {
                try {
                    return var.isEditable();
                }
                catch (CDIException cDIException) {}
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getCDIVariableObject().equals(((InternalVariable)obj).getCDIVariableObject());
            }
            return false;
        }

        public boolean isSameDescriptor(ICDIVariableDescriptor desc) {
            return this.getCDIVariableObject().equals(desc);
        }
    }
}

