/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.cdtinterface.ui;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.wizards.OpenNewWizardAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;

public class FortranWizardRegistry {
    public static final String FORTRAN_WIZARD_CATEGORY_ID = "org.eclipse.photran.ui.newFortranWizards";
    private static final String TAG_WIZARD = "wizard";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_PROJECT = "project";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_NAME = "name";
    private static final String TAG_VALUE = "value";
    private static final String ATT_FORTRAN_TYPE = "ctype";
    private static final String ATT_FORTRAN_FILE = "cfile";
    private static final String ATT_FORTRAN_FOLDER = "cfolder";
    private static final String ATT_FORTRAN_PROJECT = "cproject";
    private static final String TAG_CLASS = "class";
    private static final String TAG_ID = "id";
    private static final String PL_NEW = "newWizards";

    public static boolean isFortranProjectWizard(IConfigurationElement element) {
        String category = element.getAttribute(ATT_CATEGORY);
        return category != null && category.equals(FORTRAN_WIZARD_CATEGORY_ID);
    }

    public static String[] getProjectWizardIDs() {
        return FortranWizardRegistry.getWizardIDs(FortranWizardRegistry.getProjectWizardElements());
    }

    public static IConfigurationElement[] getProjectWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = FortranWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (FortranWizardRegistry.isProjectWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isProjectWizard(IConfigurationElement element) {
        String project = element.getAttribute(ATT_PROJECT);
        if (project != null) {
            return Boolean.valueOf(project);
        }
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_FORTRAN_PROJECT) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public static IAction[] getProjectWizardActions() {
        return FortranWizardRegistry.createActions(FortranWizardRegistry.getProjectWizardElements());
    }

    public static String[] getTypeWizardIDs() {
        return FortranWizardRegistry.getWizardIDs(FortranWizardRegistry.getTypeWizardElements());
    }

    public static IConfigurationElement[] getTypeWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = FortranWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (FortranWizardRegistry.isTypeWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isTypeWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_FORTRAN_TYPE) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public static IAction[] getTypeWizardActions() {
        return FortranWizardRegistry.createActions(FortranWizardRegistry.getTypeWizardElements());
    }

    public static String[] getFileWizardIDs() {
        return FortranWizardRegistry.getWizardIDs(FortranWizardRegistry.getFileWizardElements());
    }

    public static IConfigurationElement[] getFileWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = FortranWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (FortranWizardRegistry.isFileWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isFileWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_FORTRAN_FILE) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public static IAction[] getFolderWizardActions() {
        return FortranWizardRegistry.createActions(FortranWizardRegistry.getFolderWizardElements());
    }

    public static String[] getFolderWizardIDs() {
        return FortranWizardRegistry.getWizardIDs(FortranWizardRegistry.getFolderWizardElements());
    }

    public static IConfigurationElement[] getFolderWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = FortranWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (FortranWizardRegistry.isFolderWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isFolderWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_FORTRAN_FOLDER) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public static IAction[] getFileWizardActions() {
        return FortranWizardRegistry.createActions(FortranWizardRegistry.getFileWizardElements());
    }

    private static String[] getWizardIDs(IConfigurationElement[] elements) {
        ArrayList<String> idList = new ArrayList<String>();
        int i = 0;
        while (i < elements.length) {
            String id;
            IConfigurationElement element = elements[i];
            if (FortranWizardRegistry.isFortranProjectWizard(element) && (id = element.getAttribute(TAG_ID)) != null && !idList.contains(id)) {
                idList.add(id);
            }
            ++i;
        }
        return idList.toArray(new String[idList.size()]);
    }

    private static IAction[] createActions(IConfigurationElement[] elements) {
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<OpenNewWizardAction> actionList = new ArrayList<OpenNewWizardAction>();
        int i = 0;
        while (i < elements.length) {
            String id;
            IConfigurationElement element = elements[i];
            if (FortranWizardRegistry.isFortranProjectWizard(element) && (id = element.getAttribute(TAG_ID)) != null && !idList.contains(id)) {
                idList.add(id);
                OpenNewWizardAction action = new OpenNewWizardAction(element);
                if (action != null) {
                    actionList.add(action);
                }
            }
            ++i;
        }
        return actionList.toArray(new IAction[actionList.size()]);
    }

    public static IConfigurationElement[] getAllWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String category;
                IConfigurationElement element = elements[i];
                if (element.getName().equals(TAG_WIZARD) && (category = element.getAttribute(ATT_CATEGORY)) != null && category.equals(FORTRAN_WIZARD_CATEGORY_ID)) {
                    element.getAttribute(TAG_ID);
                    elemList.add(element);
                }
                ++i;
            }
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }
}

