/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContributedCElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.photran.cdtinterface.CDTInterfacePlugin;
import org.eclipse.photran.internal.core.lexer.Token;

public abstract class FortranElement
extends SourceManipulation
implements ICElement,
IParent,
ISourceReference,
IContributedCElement {
    protected Token identifier = null;
    static /* synthetic */ Class class$0;

    public Token getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Token identifier) {
        this.identifier = identifier;
        if (identifier != null) {
            int offset = identifier.getFileOffset();
            int length = identifier.getLength();
            int line = identifier.getLine();
            this.setIdPos(offset, length);
            this.setPos(offset, length);
            this.setLines(line, line);
        }
    }

    public FortranElement(Parent parent, Token identifier) {
        super((ICElement)parent, identifier != null ? identifier.getText() : "(anonymous)", -1);
        this.setIdentifier(identifier);
    }

    public FortranElement(Parent parent, String name) {
        super((ICElement)parent, name == null ? "(anonymous)" : name, -1);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.resource.ImageDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getBaseImageDescriptor();
        }
        return super.getAdapter(required);
    }

    protected abstract ImageDescriptor getBaseImageDescriptor();

    protected ImageDescriptor getImageDescriptorForIcon(String filename) {
        return CDTInterfacePlugin.getImageDescriptor("icons/model/" + filename);
    }

    public static class UnknownNode
    extends FortranElement {
        public UnknownNode(Parent parent, String name) {
            super(parent, name);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("unknown.gif");
        }
    }

    public static class ErrorNode
    extends FortranElement {
        public ErrorNode(Parent parent, String name) {
            super(parent, name);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("skullface.gif");
        }
    }

    public static class MainProgram
    extends FortranElement {
        public MainProgram(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("mainprogram.gif");
        }
    }

    public static class Module
    extends FortranElement {
        public Module(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("module.gif");
        }
    }

    public static class DerivedType
    extends FortranElement {
        public DerivedType(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("derivedtype.gif");
        }
    }

    public static class Function
    extends FortranElement {
        public Function(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("function.gif");
        }
    }

    public static class Subroutine
    extends FortranElement {
        public Subroutine(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("subroutine.gif");
        }
    }

    public static class BlockData
    extends FortranElement {
        public BlockData(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("subroutine.gif");
        }
    }

    public static class Variable
    extends FortranElement {
        public Variable(Parent parent, Token nameToken) {
            super(parent, nameToken);
        }

        public ImageDescriptor getBaseImageDescriptor() {
            return this.getImageDescriptorForIcon("variable.gif");
        }
    }
}

