/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.model.IPStackFrame;

public class PDebugUIUtils {
    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static IPStackFrame getCurrentStackFrame() {
        IAdaptable context = DebugUITools.getDebugContext();
        return context != null ? (IPStackFrame)context.getAdapter(IPStackFrame.class) : null;
    }

    public static String arrayToString(int[] array) {
        if (array.length == 0) {
            return "";
        }
        String msg = "";
        int preTask = array[0];
        msg = String.valueOf(msg) + preTask;
        boolean isContinue = false;
        int i = 1;
        while (i < array.length) {
            if (preTask == array[i] - 1) {
                preTask = array[i];
                isContinue = true;
                if (i == array.length - 1) {
                    msg = String.valueOf(msg) + "-" + array[i];
                    break;
                }
            } else {
                if (isContinue) {
                    msg = String.valueOf(msg) + "-" + preTask;
                }
                msg = String.valueOf(msg) + "," + array[i];
                isContinue = false;
                preTask = array[i];
            }
            ++i;
        }
        return msg;
    }

    public static String showBitList(BitList tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return "";
        }
        return PDebugUIUtils.arrayToString(tasks.toArray());
    }

    public static void main(String[] args) {
        BitList tasks = new BitList(0);
        System.out.println(PDebugUIUtils.showBitList(tasks));
    }
}

