/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.debug.core.DebugJobStorage;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;

public final class PJobVariableManager {
    private DebugJobStorage variableStorage = new DebugJobStorage("Variable");
    private DebugJobStorage varProcStorage = new DebugJobStorage("Variable_Process");
    private final String PROCESS_KEY = "process_key";

    public void shutdown() {
        this.cleanupJobVariableValues();
        this.varProcStorage.closeDebugJobStorage();
        this.variableStorage.closeDebugJobStorage();
    }

    public String getResultDisplay(String job_id, int task_id) {
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job_id, "process_key");
        if (procVal == null) {
            return "";
        }
        StringBuffer display = new StringBuffer();
        VariableValue[] values = procVal.getValues(task_id);
        int i = 0;
        while (i < values.length) {
            display.append("<i>");
            display.append(values[i].getVar());
            display.append("</i>");
            display.append(" = ");
            display.append(values[i].getVal());
            display.append("<br>");
            ++i;
        }
        return display.toString();
    }

    public DebugJobStorage getVariableStorage() {
        return this.variableStorage;
    }

    public boolean isContainVariable(IPJob job, String var) {
        return this.variableStorage.getValue(job.getIDString(), var) != null;
    }

    public void addJobVariable(IPJob job, String var, String[] sets) {
        this.addJobVariable(job, var, sets, true);
    }

    public void addJobVariable(IPJob job, String var, String[] sets, boolean enable) {
        JobVariable jVar = (JobVariable)this.variableStorage.getValue(job.getIDString(), var);
        if (jVar == null) {
            jVar = new JobVariable(job, var, sets, enable);
        } else {
            jVar.setSets(sets);
            jVar.setEnable(enable);
        }
        this.variableStorage.addValue(job.getIDString(), var, (Object)jVar);
        this.createProcessValue(job);
    }

    private void createProcessValue(IPJob job) {
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job.getIDString(), "process_key");
        if (procVal == null) {
            procVal = new ProcessValue(job.totalProcesses());
            this.varProcStorage.addValue(job.getIDString(), "process_key", (Object)procVal);
        }
    }

    public JobVariable[] getJobVariables(String job_id) {
        return (JobVariable[])this.variableStorage.getValues(job_id);
    }

    public void changeJobVariable(IPJob job, IPJob newJob, String[] sets, String var, String newVar, boolean enable) {
        this.removeJobVariable(job.getIDString(), var);
        this.addJobVariable(newJob, newVar, sets, enable);
    }

    public void deleteSet(String job_id, String set_id) {
        ArrayList<String> removeVars = new ArrayList<String>();
        Iterator i = this.variableStorage.getValueIterator(job_id);
        while (i.hasNext()) {
            JobVariable jVar = (JobVariable)i.next();
            if (!jVar.containSet(set_id)) continue;
            jVar.removeSet(set_id);
            if (jVar.getSetSize() != 0) continue;
            removeVars.add(jVar.getVar());
        }
        i = removeVars.iterator();
        while (i.hasNext()) {
            this.variableStorage.removeValue(job_id, (String)i.next());
        }
    }

    public boolean deleteSet(String job_id, String var, String set_id) {
        JobVariable jVar = (JobVariable)this.variableStorage.getValue(job_id, var);
        if (jVar == null) {
            return false;
        }
        if (!jVar.containSet(set_id)) {
            return false;
        }
        jVar.removeSet(set_id);
        if (jVar.getSetSize() == 0) {
            this.variableStorage.removeValue(job_id, jVar.getVar());
        }
        return true;
    }

    public void removeJobVariable(String job_id, String var) {
        this.variableStorage.removeValue(job_id, var);
    }

    public void removeJobVariables(String job_id) {
        this.variableStorage.removeJobStorage(job_id);
    }

    public void cleanupJobVariableValues() {
        Iterator i = this.varProcStorage.getJobValueIterator();
        while (i.hasNext()) {
            ProcessValue procVal = (ProcessValue)i.next();
            if (procVal == null) continue;
            procVal.cleanAllValues();
        }
    }

    public String[] getVariables(String job_id, String set_id, boolean enable) {
        ArrayList<String> vars = new ArrayList<String>();
        Iterator i = this.variableStorage.getValueIterator(job_id);
        while (i.hasNext()) {
            JobVariable jVar = (JobVariable)i.next();
            if (jVar.isEnable() != enable || !jVar.containSet(set_id)) continue;
            vars.add(jVar.getVar());
        }
        return vars.toArray(new String[0]);
    }

    public void updateJobVariableValues(String job_id, String set_id, IProgressMonitor monitor) throws CoreException {
        PCDIDebugModel debugModel;
        IPCDISession session;
        String[] vars;
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job_id, "process_key");
        if (procVal != null && (vars = this.getVariables(job_id, set_id, true)).length > 0 && (session = (debugModel = PTPDebugCorePlugin.getDebugModel()).getPCDISession(job_id)) != null) {
            int[] tasks = session.getDebugger().filterRunningTasks(debugModel.getTasks(job_id, set_id)).toArray();
            int length = tasks.length;
            monitor.beginTask("Updating variables value...", length * vars.length + 1);
            int i = 0;
            while (i < length) {
                if (!monitor.isCanceled()) {
                    VariableValue[] values = new VariableValue[vars.length];
                    int j = 0;
                    while (j < vars.length) {
                        String val = debugModel.getValue(session, tasks[i], vars[j], monitor);
                        values[j] = new VariableValue(vars[j], val);
                        ++j;
                    }
                    procVal.setValues(tasks[i], values);
                }
                ++i;
            }
        }
        monitor.done();
    }

    public class JobVariable {
        IPJob job;
        String var;
        String[] sets = new String[0];
        boolean enable = false;

        public JobVariable(IPJob job, String var, String[] sets, boolean enable) {
            this.job = job;
            this.var = var;
            this.sets = sets;
            this.enable = enable;
        }

        public IPJob getJob() {
            return this.job;
        }

        public String getVar() {
            return this.var;
        }

        public String[] getSets() {
            return this.sets;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public boolean containSet(String set_id) {
            int i = 0;
            while (i < this.sets.length) {
                if (this.sets[i].equals(set_id)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void addSet(String set_id) {
            String[] newSets = new String[this.sets.length + 1];
            System.arraycopy(this.sets, 0, newSets, 0, this.sets.length);
            newSets[this.sets.length] = set_id;
            this.setSets(newSets);
        }

        public void removeSet(String set_id) {
            String[] newSets = new String[this.sets.length - 1];
            int i = 0;
            int j = 0;
            while (i < this.sets.length) {
                if (!this.sets[i].equals(set_id)) {
                    newSets[j] = this.sets[i];
                    ++j;
                }
                ++i;
            }
            this.setSets(newSets);
        }

        public int getSetSize() {
            return this.sets.length;
        }

        public void setVar(String var) {
            this.var = var;
        }

        public void setSets(String[] sets) {
            this.sets = sets;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    class VariableValue {
        String var;
        String val;

        VariableValue(String var, String val) {
            this.var = var;
            this.val = val;
        }

        String getVar() {
            return this.var;
        }

        String getVal() {
            return this.val;
        }

        void setVar(String var) {
            this.var = var;
        }

        void setVal(String val) {
            this.val = val;
        }
    }

    class ProcessValue {
        int total = 0;
        Object[] processValues = new Object[0];

        ProcessValue(int total) {
            this.total = total;
            this.processValues = new Object[total];
        }

        void checkValidTask(int task_id) {
            if (task_id > this.processValues.length) {
                throw new IllegalArgumentException("Invalid task id");
            }
        }

        void setValues(int task_id, VariableValue[] values) {
            this.checkValidTask(task_id);
            this.processValues[task_id] = values;
        }

        VariableValue[] getValues(int task_id) {
            this.checkValidTask(task_id);
            Object object = this.processValues[task_id];
            if (object instanceof VariableValue[]) {
                return (VariableValue[])object;
            }
            return new VariableValue[0];
        }

        void addValue(int task_id, VariableValue value) {
            VariableValue[] values = this.getValues(task_id);
            VariableValue[] newValues = new VariableValue[values.length + 1];
            if (values.length > 0) {
                System.arraycopy(values, 0, newValues, 0, values.length);
            }
            newValues[values.length] = value;
            this.setValues(task_id, newValues);
        }

        void updateValue(int task_id, VariableValue value) {
            VariableValue[] values = this.getValues(task_id);
            int i = 0;
            while (i < values.length) {
                if (values[i].getVar().equals(value.getVar())) {
                    values[i].setVal(value.getVal());
                }
                ++i;
            }
        }

        void cleanValues(int task_id) {
            this.processValues[task_id] = null;
        }

        void cleanAllValues() {
            this.processValues = new Object[this.total];
        }
    }
}

