/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.internal.ui.actions.RegisterAction;
import org.eclipse.ptp.debug.internal.ui.actions.ResumeAction;
import org.eclipse.ptp.debug.internal.ui.actions.StepIntoAction;
import org.eclipse.ptp.debug.internal.ui.actions.StepOverAction;
import org.eclipse.ptp.debug.internal.ui.actions.StepReturnAction;
import org.eclipse.ptp.debug.internal.ui.actions.SuspendAction;
import org.eclipse.ptp.debug.internal.ui.actions.TerminateAction;
import org.eclipse.ptp.debug.internal.ui.actions.UnregisterAction;
import org.eclipse.ptp.debug.internal.ui.views.AbstractPDebugEventHandler;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.views.ParallelDebugViewEventHandler;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;
import org.eclipse.ptp.ui.views.ParallelJobView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.WorkbenchJob;

public class ParallelDebugView
extends ParallelJobView {
    protected ParallelAction resumeAction = null;
    protected ParallelAction suspendAction = null;
    protected ParallelAction terminateAction = null;
    protected ParallelAction stepIntoAction = null;
    protected ParallelAction stepOverAction = null;
    protected ParallelAction stepReturnAction = null;
    protected ParallelAction registerAction = null;
    protected ParallelAction unregisterAction = null;
    protected AbstractPDebugEventHandler fEventHandler = null;
    protected Viewer launchViewer = null;
    private ISelectionChangedListener debugViewSelectChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && ((AbstractParallelElementView)ParallelDebugView.this).canvas != null && !((AbstractParallelElementView)ParallelDebugView.this).canvas.isDisposed()) {
                ((AbstractParallelElementView)ParallelDebugView.this).canvas.unselectAllElements();
                for (Object obj : (IStructuredSelection)selection) {
                    if (!(obj instanceof IPDebugElement)) continue;
                    int taskID = ((IPDebugTarget)((IPDebugElement)obj).getDebugTarget()).getTargetID();
                    if (((AbstractParallelElementView)ParallelDebugView.this).canvas.isSelected(taskID)) continue;
                    ((AbstractParallelElementView)ParallelDebugView.this).canvas.selectElement(taskID);
                }
                ((AbstractParallelElementView)ParallelDebugView.this).canvas.redraw();
            }
        }
    };

    public ParallelDebugView(IManager manager) {
        super(manager);
    }

    public ParallelDebugView() {
        this((IManager)PTPDebugUIPlugin.getUIDebugManager());
    }

    public void dispose() {
        Viewer viewer = this.getDebugViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener(this.debugViewSelectChangedListener);
        }
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
        super.dispose();
    }

    protected Viewer getDebugViewer() {
        if (this.launchViewer == null) {
            IViewPart part = this.getViewSite().getPage().findView("org.eclipse.debug.ui.DebugView");
            if (part == null) {
                try {
                    part = this.getViewSite().getPage().showView("org.eclipse.debug.ui.DebugView");
                }
                catch (PartInitException partInitException) {
                    return null;
                }
            }
            if (part != null && part instanceof AbstractDebugView) {
                this.launchViewer = ((AbstractDebugView)part).getViewer();
            }
        }
        return this.launchViewer;
    }

    protected void setEventHandler(AbstractPDebugEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected AbstractPDebugEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    public void createView(Composite parent) {
        super.createView(parent);
        this.setEventHandler(new ParallelDebugViewEventHandler(this));
        Viewer viewer = this.getDebugViewer();
        if (viewer != null) {
            viewer.addSelectionChangedListener(this.debugViewSelectChangedListener);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("threadGroup"));
        manager.add((IContributionItem)new Separator("stepGroup"));
        manager.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        manager.add((IContributionItem)new GroupMarker("stepOverGroup"));
        manager.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        manager.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        manager.add((IContributionItem)new Separator("regGroup"));
        manager.appendToGroup("threadGroup", (IAction)this.resumeAction);
        manager.appendToGroup("threadGroup", (IAction)this.suspendAction);
        manager.appendToGroup("threadGroup", (IAction)this.terminateAction);
        manager.appendToGroup("stepIntoGroup", (IAction)this.stepIntoAction);
        manager.appendToGroup("stepOverGroup", (IAction)this.stepOverAction);
        manager.appendToGroup("emptyStepGroup", (IAction)this.stepReturnAction);
    }

    protected void createToolBarActionGroup(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IContributionItem)new Separator("threadGroup"));
        toolBarMgr.add((IContributionItem)new Separator("stepGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("stepOverGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        toolBarMgr.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        toolBarMgr.add((IContributionItem)new Separator("regGroup"));
        super.createToolBarActionGroup(toolBarMgr);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.resumeAction = new ResumeAction(this);
        this.suspendAction = new SuspendAction(this);
        this.terminateAction = new TerminateAction(this);
        this.stepIntoAction = new StepIntoAction(this);
        this.stepOverAction = new StepOverAction(this);
        this.stepReturnAction = new StepReturnAction(this);
        this.registerAction = new RegisterAction(this);
        this.unregisterAction = new UnregisterAction(this);
        toolBarMgr.appendToGroup("threadGroup", (IAction)this.resumeAction);
        toolBarMgr.appendToGroup("threadGroup", (IAction)this.suspendAction);
        toolBarMgr.appendToGroup("threadGroup", (IAction)this.terminateAction);
        toolBarMgr.appendToGroup("stepIntoGroup", (IAction)this.stepIntoAction);
        toolBarMgr.appendToGroup("stepOverGroup", (IAction)this.stepOverAction);
        toolBarMgr.appendToGroup("stepReturnGroup", (IAction)this.stepReturnAction);
        toolBarMgr.appendToGroup("regGroup", (IAction)this.registerAction);
        toolBarMgr.appendToGroup("regGroup", (IAction)this.unregisterAction);
        super.buildInToolBarActions(toolBarMgr);
    }

    protected void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IContributionItem)new Separator());
    }

    public void handleAction(int type, int index) {
        IElement element = this.canvas.getElement(index);
        if (type == 5) {
            this.doubleClick(element);
        }
    }

    public void doubleClick(IElement element) {
        try {
            this.registerElement(element);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.errorDialog(this.getViewSite().getShell(), "Error", e.getStatus());
        }
    }

    public String[] getToolTipText(Object obj) {
        String[] header = super.getToolTipText(obj);
        String variableText = ((UIDebugManager)this.manager).getValueText(((IPProcess)obj).getTaskId());
        if (variableText != null && variableText.length() > 0) {
            return new String[]{header[0], variableText};
        }
        return header;
    }

    public void registerElement(IElement element) throws CoreException {
        if (element.isRegistered()) {
            ((UIDebugManager)this.manager).unregisterElements(new IElement[]{element});
        } else {
            ((UIDebugManager)this.manager).registerElements(new IElement[]{element});
        }
    }

    public void registerSelectedElements() throws CoreException {
        if (this.cur_element_set != null) {
            ((UIDebugManager)this.manager).registerElements(this.canvas.getSelectedElements());
        }
    }

    public void unregisterSelectedElements() throws CoreException {
        if (this.cur_element_set != null) {
            ((UIDebugManager)this.manager).unregisterElements(this.canvas.getSelectedElements());
        }
    }

    public void updateAction() {
        super.updateAction();
        IPJob job = ((UIDebugManager)this.manager).findJobById(this.getCurrentID());
        boolean isDebugMode = ((UIDebugManager)this.manager).isDebugMode(job);
        boolean isRunning = ((UIDebugManager)this.manager).isRunning(job);
        this.registerAction.setEnabled(isRunning && isDebugMode);
        this.unregisterAction.setEnabled(isRunning && isDebugMode);
        this.suspendAction.setEnabled(isRunning && isDebugMode);
        this.terminateAction.setEnabled(isRunning);
        if (isRunning && isDebugMode) {
            IElementHandler elementHandler = this.getCurrentElementHandler();
            if (elementHandler != null) {
                BitList suspendedTaskList = (BitList)job.getAttribute("suspended");
                BitList terminatedTaskList = (BitList)job.getAttribute("terminated");
                this.updateDebugButtons(terminatedTaskList, suspendedTaskList);
            }
        } else {
            this.resumeAction.setEnabled(false);
            this.stepIntoAction.setEnabled(false);
            this.stepOverAction.setEnabled(false);
            this.suspendAction.setEnabled(false);
        }
    }

    public void updateDebugButtons(BitList terminatedTasks, BitList suspendedTasks) {
        int totalSuspendedSize;
        IElementSet set = this.getCurrentSet();
        if (set == null || terminatedTasks == null) {
            return;
        }
        int setSize = set.size();
        int totalTerminatedSize = terminatedTasks.cardinality();
        int n = totalSuspendedSize = suspendedTasks == null || suspendedTasks.isEmpty() ? 0 : suspendedTasks.cardinality();
        if (!set.isRootSet()) {
            try {
                BitList setTasks = ((UIDebugManager)this.manager).getTasks(this.getCurrentID(), set.getID());
                setSize = setTasks.cardinality();
                BitList refTasks = terminatedTasks.copy();
                refTasks.and(setTasks);
                totalTerminatedSize = refTasks.cardinality();
                if (setSize != totalTerminatedSize) {
                    BitList tarRefTasks = suspendedTasks.copy();
                    tarRefTasks.and(setTasks);
                    totalSuspendedSize = tarRefTasks.cardinality();
                }
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
        }
        boolean enabledTerminatedButton = setSize != totalTerminatedSize;
        this.terminateAction.setEnabled(enabledTerminatedButton);
        if (enabledTerminatedButton) {
            this.resumeAction.setEnabled(totalSuspendedSize > 0);
            boolean enableStepButtons = setSize == totalSuspendedSize + totalTerminatedSize;
            this.stepIntoAction.setEnabled(enableStepButtons);
            this.stepOverAction.setEnabled(enableStepButtons);
            this.suspendAction.setEnabled(!enableStepButtons);
        } else {
            this.resumeAction.setEnabled(false);
            this.stepIntoAction.setEnabled(false);
            this.stepOverAction.setEnabled(false);
            this.suspendAction.setEnabled(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IElement element;
        IStructuredSelection structSelection;
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structSelection = (IStructuredSelection)selection).size() == 1 && (element = (IElement)structSelection.getFirstElement()).isRegistered()) {
            this.focusOnDebugTarget(this.getCheckedJob(), element.getIDNum());
        }
    }

    public void focusOnDebugTarget(final IPJob job, final int task_id) {
        final UIDebugManager uimanager = (UIDebugManager)this.manager;
        WorkbenchJob workjob = new WorkbenchJob("Focus on Debug View"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ParallelDebugView.this.focusOnDebugView(uimanager.getDebugObject(job, task_id));
                return Status.OK_STATUS;
            }
        };
        workjob.setPriority(50);
        workjob.schedule();
    }

    private void focusOnDebugView(final Object selection) {
        if (selection == null) {
            return;
        }
        if (PTPDebugUIPlugin.getDisplay().getThread() == Thread.currentThread()) {
            this.doOnFocusDebugView(selection);
        } else {
            WorkbenchJob job = new WorkbenchJob("Focus on Debug View"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ParallelDebugView.this.doOnFocusDebugView(selection);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.setSystem(true);
            job.schedule();
        }
    }

    private void expendDebugView(AsynchronousTreeViewer asynViewer, Object selection) {
        TreePath[] treePaths = asynViewer.getTreePaths(selection);
        if (treePaths.length == 0) {
            if (selection instanceof IStackFrame) {
                this.expendDebugView(asynViewer, ((IStackFrame)selection).getLaunch());
            } else if (selection instanceof IThread) {
                this.expendDebugView(asynViewer, ((IThread)selection).getLaunch());
            } else if (selection instanceof IDebugTarget) {
                this.expendDebugView(asynViewer, ((IDebugTarget)selection).getLaunch());
            }
        }
        if (treePaths.length > 0) {
            asynViewer.expand((ISelection)new TreeSelection(treePaths[0]));
        }
    }

    private void doOnFocusDebugView(Object selection) {
        Viewer viewer = this.getDebugViewer();
        if (viewer instanceof AsynchronousTreeViewer) {
            AsynchronousTreeViewer asynViewer = (AsynchronousTreeViewer)viewer;
            this.expendDebugView(asynViewer, selection);
            this.focusOnDebugTarget(asynViewer, selection);
        }
    }

    private void focusOnDebugTarget(final AsynchronousTreeViewer asynViewer, final Object selection) {
        WorkbenchJob job = new WorkbenchJob("Focus on Debug Target"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TreePath[] treePaths = asynViewer.getTreePaths(selection);
                if (treePaths.length > 0) {
                    asynViewer.setSelection((ISelection)new TreeSelection(treePaths[0]), true, true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }
}

