/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.core.PySystemState;

public class SyspathArchive
extends PyString {
    private ZipFile zipFile;

    static String getArchiveName(String dir) {
        String lowerName = dir.toLowerCase();
        int idx = lowerName.indexOf(".zip");
        if (idx < 0) {
            idx = lowerName.indexOf(".jar");
        }
        if (idx < 0) {
            return null;
        }
        if (idx == dir.length() - 4) {
            return dir;
        }
        char ch = dir.charAt(idx + 4);
        if (ch == File.separatorChar || ch == '/') {
            return dir.substring(0, idx + 4);
        }
        return null;
    }

    public SyspathArchive makeSubfolder(String folder) {
        return new SyspathArchive(this.zipFile, super.toString() + "/" + folder);
    }

    private final String makeEntry(String entry) {
        String archive = super.toString();
        String folder = SyspathArchive.getArchiveName(super.toString());
        if (archive.length() == folder.length()) {
            return entry;
        }
        return archive.substring(folder.length() + 1) + "/" + entry;
    }

    ZipEntry getEntry(String entryName) {
        return this.zipFile.getEntry(this.makeEntry(entryName));
    }

    InputStream getInputStream(ZipEntry entry) throws IOException {
        InputStream istream = this.zipFile.getInputStream(entry);
        int len = (int)entry.getSize();
        byte[] buffer = new byte[len];
        int off = 0;
        while (len > 0) {
            int l = istream.read(buffer, off, buffer.length - off);
            if (l < 0) {
                return null;
            }
            off += l;
            len -= l;
        }
        istream.close();
        return new ByteArrayInputStream(buffer);
    }

    public SyspathArchive(String archiveName) throws IOException {
        super(archiveName);
        archiveName = SyspathArchive.getArchiveName(archiveName);
        this.zipFile = new ZipFile(new File(archiveName));
        Py.getSystemState();
        PySystemState.packageManager.addJar(archiveName, false);
    }

    SyspathArchive(ZipFile zipFile, String archiveName) {
        super(archiveName);
        this.zipFile = zipFile;
    }
}

