/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.core.util;

import org.eclipse.photran.internal.core.lexer.Token;

public final class OffsetLength {
    private int offset = 0;
    private int length = 0;

    public OffsetLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public static boolean contains(int offset, int length, int otherOffset, int otherLength) {
        return offset <= otherOffset && OffsetLength.getPositionPastEnd(otherOffset, otherLength) <= OffsetLength.getPositionPastEnd(offset, length);
    }

    public static boolean contains(int offset, int length, OffsetLength other) {
        return other != null && OffsetLength.contains(offset, length, other.offset, other.length);
    }

    public boolean contains(OffsetLength other) {
        return OffsetLength.contains(this.offset, this.length, other);
    }

    public boolean containsFileRange(Token token) {
        return OffsetLength.contains(this.offset, this.length, token.getFileOffset(), token.getLength());
    }

    public boolean equals(OffsetLength other) {
        return this.offset == other.offset && this.length == other.length;
    }

    public boolean isOnOrAfter(int targetOffset) {
        return this.offset >= targetOffset;
    }

    public boolean isBefore(int targetOffset) {
        return this.offset < targetOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = Math.max(offset, 0);
    }

    public int getLength() {
        return this.length;
    }

    public static int getPositionPastEnd(int offset, int length) {
        return offset + Math.max(length, 1);
    }

    public int getPositionPastEnd() {
        return OffsetLength.getPositionPastEnd(this.offset, this.length);
    }

    public void setLength(int length) {
        this.length = Math.max(length, 0);
    }

    public String toString() {
        return "offset " + this.offset + ", length " + this.length;
    }
}

