/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.errorparsers;

import java.util.Stack;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class G95FortranErrorParser
implements IErrorParser {
    private IErrorState state = new InFileSearchState();
    private String fileNameString;
    private int lineNumber;
    private Stack lines;

    public boolean processLine(String line, ErrorParserManager epm) {
        try {
            return this.state.processLine(line, epm);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static interface IErrorState {
        public boolean processLine(String var1, ErrorParserManager var2);
    }

    private class InFileSearchState
    implements IErrorState {
        private InFileSearchState() {
        }

        public boolean processLine(String line, ErrorParserManager epm) {
            if (line.startsWith("In file") || line.startsWith(" In file")) {
                String[] tokens = line.split(" ");
                tokens = tokens[2].split(":");
                G95FortranErrorParser.this.fileNameString = tokens[0];
                String lineNumberString = tokens[1];
                G95FortranErrorParser.this.lineNumber = Integer.parseInt(lineNumberString);
                G95FortranErrorParser.this.lines = new Stack();
                G95FortranErrorParser.this.lines.push(line);
                G95FortranErrorParser.this.state = new ErrorOrWarningSearchState();
            }
            return false;
        }
    }

    private class ErrorOrWarningSearchState
    implements IErrorState {
        private ErrorOrWarningSearchState() {
        }

        public boolean processLine(String line, ErrorParserManager epm) {
            if (line.startsWith("Error") || line.startsWith(" Error") || line.startsWith("Warning") || line.startsWith(" Warning")) {
                IFile file = epm.findFilePath(G95FortranErrorParser.this.fileNameString);
                int severity = line.startsWith("Error") || line.startsWith(" Error") ? 2 : 1;
                epm.generateMarker((IResource)file, G95FortranErrorParser.this.lineNumber, line, severity, null);
                G95FortranErrorParser.this.lines.pop();
                G95FortranErrorParser.this.lines.pop();
                G95FortranErrorParser.this.state = new InFileSearchState();
            } else {
                G95FortranErrorParser.this.lines.push(line);
            }
            return false;
        }
    }
}

