/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutputType
extends BuildObject
implements IOutputType {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = new String();
    private IOutputType superClass;
    private String superClassId;
    private ITool parent;
    private String outputContentTypeId;
    private IContentType outputContentType;
    private String outputs;
    private String optionId;
    private String buildVariable;
    private Boolean multipleOfType;
    private String primaryInputTypeId;
    private IInputType primaryInputType;
    private Boolean primaryOutput;
    private String outputPrefix;
    private String outputNames;
    private String namePattern;
    private IConfigurationElement nameProviderElement = null;
    private IManagedOutputNameProvider nameProvider = null;
    private boolean isExtensionOutputType = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private boolean rebuildState;

    public OutputType(ITool parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionOutputType = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionOutputType(this);
    }

    public OutputType(Tool parent, IOutputType superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOutputType = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionOutputType(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public OutputType(ITool parent, Element element) {
        this.parent = parent;
        this.isExtensionOutputType = false;
        this.loadFromProject(element);
    }

    public OutputType(ITool parent, String Id, String name, OutputType outputType) {
        this.parent = parent;
        this.superClass = outputType.superClass;
        if (this.superClass != null && outputType.superClassId != null) {
            this.superClassId = new String(outputType.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOutputType = false;
        if (outputType.outputContentTypeId != null) {
            this.outputContentTypeId = new String(outputType.outputContentTypeId);
        }
        this.outputContentType = outputType.outputContentType;
        if (outputType.outputs != null) {
            this.outputs = new String(outputType.outputs);
        }
        if (outputType.optionId != null) {
            this.optionId = new String(outputType.optionId);
        }
        if (outputType.buildVariable != null) {
            this.buildVariable = new String(outputType.buildVariable);
        }
        if (outputType.multipleOfType != null) {
            this.multipleOfType = new Boolean(outputType.multipleOfType);
        }
        if (outputType.primaryInputTypeId != null) {
            this.primaryInputTypeId = new String(outputType.primaryInputTypeId);
        }
        this.primaryInputType = outputType.primaryInputType;
        if (outputType.primaryOutput != null) {
            this.primaryOutput = new Boolean(outputType.primaryOutput);
        }
        if (outputType.outputPrefix != null) {
            this.outputPrefix = new String(outputType.outputPrefix);
        }
        if (outputType.outputNames != null) {
            this.outputNames = new String(outputType.outputNames);
        }
        if (outputType.namePattern != null) {
            this.namePattern = new String(outputType.namePattern);
        }
        this.nameProviderElement = outputType.nameProviderElement;
        this.nameProvider = outputType.nameProvider;
        this.setDirty(true);
        this.setRebuildState(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.outputContentTypeId = element.getAttribute("outputContentType");
        this.outputs = element.getAttribute("outputs");
        this.optionId = element.getAttribute("option");
        String isMOT = element.getAttribute("multipleOfType");
        if (isMOT != null) {
            this.multipleOfType = new Boolean("true".equals(isMOT));
        }
        this.primaryInputTypeId = element.getAttribute("primaryInputType");
        String isPO = element.getAttribute("primaryOutput");
        if (isPO != null) {
            this.primaryOutput = new Boolean("true".equals(isPO));
        }
        this.outputPrefix = element.getAttribute("outputPrefix");
        this.outputNames = element.getAttribute("outputNames");
        this.namePattern = element.getAttribute("namePattern");
        this.buildVariable = element.getAttribute("buildVariable");
        String nameProvider = element.getAttribute("nameProvider");
        if (nameProvider != null && element instanceof DefaultManagedConfigElement) {
            this.nameProviderElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected void loadFromProject(Element element) {
        String isPO;
        String isMOT;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionOutputType(this.superClassId);
        }
        if (element.hasAttribute("outputContentType")) {
            this.outputContentTypeId = element.getAttribute("outputContentType");
        }
        if (element.hasAttribute("outputs")) {
            this.outputs = element.getAttribute("outputs");
        }
        if (element.hasAttribute("option")) {
            this.optionId = element.getAttribute("option");
        }
        if (element.hasAttribute("multipleOfType") && (isMOT = element.getAttribute("multipleOfType")) != null) {
            this.multipleOfType = new Boolean("true".equals(isMOT));
        }
        if (element.hasAttribute("primaryInputType")) {
            this.primaryInputTypeId = element.getAttribute("primaryInputType");
            this.primaryInputType = this.parent.getInputTypeById(this.primaryInputTypeId);
        }
        if (element.hasAttribute("primaryOutput") && (isPO = element.getAttribute("primaryOutput")) != null) {
            this.primaryOutput = new Boolean("true".equals(isPO));
        }
        if (element.hasAttribute("outputPrefix")) {
            this.outputPrefix = element.getAttribute("outputPrefix");
        }
        if (element.hasAttribute("outputNames")) {
            this.outputNames = element.getAttribute("outputNames");
        }
        if (element.hasAttribute("namePattern")) {
            this.namePattern = element.getAttribute("namePattern");
        }
        if (element.hasAttribute("buildVariable")) {
            this.buildVariable = element.getAttribute("buildVariable");
        }
        element.hasAttribute("nameProvider");
    }

    public void serialize(Document doc, Element element) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.outputContentTypeId != null) {
            element.setAttribute("outputContentType", this.outputContentTypeId);
        }
        if (this.outputs != null) {
            element.setAttribute("outputs", this.outputs);
        }
        if (this.optionId != null) {
            element.setAttribute("option", this.optionId);
        }
        if (this.multipleOfType != null) {
            element.setAttribute("multipleOfType", this.multipleOfType.toString());
        }
        if (this.primaryInputTypeId != null) {
            element.setAttribute("primaryInputType", this.primaryInputTypeId);
        }
        if (this.primaryOutput != null) {
            element.setAttribute("primaryOutput", this.primaryOutput.toString());
        }
        if (this.outputPrefix != null) {
            element.setAttribute("outputPrefix", this.outputPrefix);
        }
        if (this.outputNames != null) {
            element.setAttribute("outputNames", this.outputNames);
        }
        if (this.namePattern != null) {
            element.setAttribute("namePattern", this.namePattern);
        }
        if (this.buildVariable != null) {
            element.setAttribute("buildVariable", this.buildVariable);
        }
        this.isDirty = false;
    }

    public ITool getParent() {
        return this.parent;
    }

    public IOutputType getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public String getBuildVariable() {
        if (this.buildVariable == null) {
            if (this.superClass != null) {
                return this.superClass.getBuildVariable();
            }
            String name = this.getName();
            if (name == null || name.length() == 0) {
                name = this.getId();
            }
            String defaultName = name.toUpperCase();
            defaultName = defaultName.replaceAll("\\W", "_");
            defaultName = String.valueOf(defaultName) + "_OUTPUTS";
            return defaultName;
        }
        return this.buildVariable;
    }

    public void setBuildVariable(String variableName) {
        if (variableName == null && this.buildVariable == null) {
            return;
        }
        if (this.buildVariable == null || variableName == null || !variableName.equals(this.buildVariable)) {
            this.buildVariable = variableName;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public boolean getMultipleOfType() {
        if (this.multipleOfType == null) {
            if (this.superClass != null) {
                return this.superClass.getMultipleOfType();
            }
            return false;
        }
        return this.multipleOfType;
    }

    public void setMultipleOfType(boolean b) {
        if (this.multipleOfType == null || b != this.multipleOfType) {
            this.multipleOfType = new Boolean(b);
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String getNamePattern() {
        if (this.namePattern == null) {
            if (this.superClass != null) {
                return this.superClass.getNamePattern();
            }
            return EMPTY_STRING;
        }
        return this.namePattern;
    }

    public void setNamePattern(String pattern) {
        if (pattern == null && this.namePattern == null) {
            return;
        }
        if (this.namePattern == null || pattern == null || !pattern.equals(this.namePattern)) {
            this.namePattern = pattern;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IConfigurationElement getNameProviderElement() {
        if (this.nameProviderElement == null && this.superClass != null) {
            return ((OutputType)this.superClass).getNameProviderElement();
        }
        return this.nameProviderElement;
    }

    public void setNameProviderElement(IConfigurationElement element) {
        this.nameProviderElement = element;
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public IManagedOutputNameProvider getNameProvider() {
        if (this.nameProvider != null) {
            return this.nameProvider;
        }
        IConfigurationElement element = this.getNameProviderElement();
        if (element != null) {
            try {
                if (element.getAttribute("nameProvider") != null) {
                    this.nameProvider = (IManagedOutputNameProvider)element.createExecutableExtension("nameProvider");
                    return this.nameProvider;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String getOptionId() {
        if (this.optionId == null) {
            if (this.superClass != null) {
                return this.superClass.getOptionId();
            }
            return null;
        }
        return this.optionId;
    }

    public void setOptionId(String id) {
        if (id == null && this.optionId == null) {
            return;
        }
        if (id == null || this.optionId == null || !this.optionId.equals(id)) {
            this.optionId = id;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IContentType getOutputContentType() {
        if (this.outputContentType == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputContentType();
            }
            return null;
        }
        return this.outputContentType;
    }

    public void setOutputContentType(IContentType type) {
        if (this.outputContentType != type) {
            this.outputContentType = type;
            this.outputContentTypeId = this.outputContentType != null ? this.outputContentType.getId() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String[] getOutputExtensionsAttribute() {
        if (this.outputs == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputExtensionsAttribute();
            }
            return null;
        }
        return this.outputs.split(DEFAULT_SEPARATOR);
    }

    public void setOutputExtensionsAttribute(String exts) {
        if (exts == null && this.outputs == null) {
            return;
        }
        if (this.outputs == null || exts == null || !exts.equals(this.outputs)) {
            this.outputs = exts;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String[] getOutputExtensions(ITool tool) {
        IContentType type = this.getOutputContentType();
        if (type != null) {
            return ((Tool)tool).getContentTypeFileSpecs(type);
        }
        return this.getOutputExtensionsAttribute();
    }

    public boolean isOutputExtension(ITool tool, String ext) {
        String[] exts = this.getOutputExtensions(tool);
        if (exts != null) {
            int i = 0;
            while (i < exts.length) {
                if (ext.equals(exts[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getOutputPrefix() {
        if (this.outputPrefix == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputPrefix();
            }
            return EMPTY_STRING;
        }
        return this.outputPrefix;
    }

    public void setOutputPrefix(String prefix) {
        if (prefix == null && this.outputPrefix == null) {
            return;
        }
        if (this.outputPrefix == null || prefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String[] getOutputNames() {
        if (this.outputNames == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputNames();
            }
            return null;
        }
        String[] nameTokens = this.outputNames.split(";");
        return nameTokens;
    }

    public void setOutputNames(String names) {
        if (names == null && this.outputNames == null) {
            return;
        }
        if (this.outputNames == null || names == null || !names.equals(this.outputNames)) {
            this.outputNames = names;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IInputType getPrimaryInputType() {
        IInputType ret = this.primaryInputType;
        if (ret == null) {
            if (this.superClass != null) {
                ret = this.superClass.getPrimaryInputType();
            }
            if (ret == null) {
                ret = this.getParent().getPrimaryInputType();
            }
        }
        return ret;
    }

    public void setPrimaryInputType(IInputType type) {
        if (this.primaryInputType != type) {
            this.primaryInputType = type;
            this.primaryInputTypeId = this.primaryInputType != null ? this.primaryInputType.getId() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public boolean getPrimaryOutput() {
        if (this.primaryOutput == null) {
            if (this.superClass != null) {
                return this.superClass.getPrimaryOutput();
            }
            return false;
        }
        return this.primaryOutput;
    }

    public void setPrimaryOutput(boolean b) {
        if (this.primaryOutput == null || b != this.primaryOutput) {
            this.primaryOutput = new Boolean(b);
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public boolean isExtensionElement() {
        return this.isExtensionOutputType;
    }

    public boolean isDirty() {
        if (this.isExtensionOutputType) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionOutputType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "outputType", this.getId());
                }
            }
            IContentTypeManager manager = Platform.getContentTypeManager();
            if (this.outputContentTypeId != null && this.outputContentTypeId.length() > 0) {
                this.outputContentType = manager.getContentType(this.outputContentTypeId);
            }
            if (this.primaryInputTypeId != null && this.primaryInputTypeId.length() > 0) {
                this.primaryInputType = this.parent.getInputTypeById(this.primaryInputTypeId);
            }
        }
    }

    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public boolean needsRebuild() {
        return this.rebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.rebuildState = rebuild;
    }
}

