/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MbsEnvironmentSupplier
implements IEnvironmentVariableSupplier {
    private static final String[] fVariableNames = new String[]{"CWD", "PWD"};

    public IBuildEnvironmentVariable getVariable(String name, Object context) {
        if (context instanceof IConfiguration) {
            return this.getConfigurationVariable(name, (IConfiguration)context);
        }
        return null;
    }

    public IBuildEnvironmentVariable getConfigurationVariable(String name, IConfiguration configuration) {
        IManagedBuildInfo info;
        IResource owner;
        BuildEnvVar variable = null;
        if (("CWD".equals(name) || "PWD".equals(name)) && (owner = configuration.getOwner()) != null && (info = ManagedBuildManager.getBuildInfo(owner)) != null && configuration.equals(info.getDefaultConfiguration())) {
            IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getBuildfileGenerator(configuration);
            generator.initialize((IProject)owner, info, null);
            IPath topBuildDir = generator.getBuildWorkingDir();
            if (topBuildDir == null) {
                topBuildDir = new Path(info.getConfigurationName());
            }
            IPath projectLocation = owner.getLocation();
            IPath workingDirectory = projectLocation.append(topBuildDir);
            String value = workingDirectory.toOSString();
            variable = new BuildEnvVar(name, value, 1, null);
        }
        return variable;
    }

    public IBuildEnvironmentVariable[] getVariables(Object context) {
        if (context instanceof IConfiguration) {
            ArrayList<IBuildEnvironmentVariable> variables = new ArrayList<IBuildEnvironmentVariable>(fVariableNames.length);
            int i = 0;
            while (i < fVariableNames.length) {
                IBuildEnvironmentVariable var = this.getConfigurationVariable(fVariableNames[i], (IConfiguration)context);
                if (var != null) {
                    variables.add(var);
                }
                ++i;
            }
            if (variables.size() == 0) {
                return null;
            }
            return variables.toArray(new IBuildEnvironmentVariable[variables.size()]);
        }
        return null;
    }
}

