/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvVar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StorableEnvironment {
    public static final String ENVIRONMENT_ELEMENT_NAME = "environment";
    private Map fVariables;
    private boolean fIsDirty = false;
    private boolean fIsChanged = false;

    private Map getMap() {
        if (this.fVariables == null) {
            this.fVariables = new HashMap();
        }
        return this.fVariables;
    }

    public StorableEnvironment() {
    }

    public StorableEnvironment(Element element) {
        this.load(element);
    }

    private void load(Element element) {
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("variable")) {
                this.addVariable(new StorableEnvVar((Element)node));
            }
            ++i;
        }
        this.fIsDirty = false;
        this.fIsChanged = false;
    }

    public void serialize(Document doc, Element element) {
        if (this.fVariables != null) {
            Iterator iter = this.fVariables.values().iterator();
            while (iter.hasNext()) {
                StorableEnvVar var = (StorableEnvVar)iter.next();
                Element varEl = doc.createElement("variable");
                element.appendChild(varEl);
                var.serialize(doc, varEl);
            }
        }
        this.fIsDirty = false;
    }

    private void addVariable(IBuildEnvironmentVariable var) {
        String name = var.getName();
        if (name == null) {
            return;
        }
        IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
        if (!provider.isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        this.getMap().put(name, var);
    }

    public IBuildEnvironmentVariable createVariable(String name, String value, int op, String delimiter) {
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        IBuildEnvironmentVariable var = this.checkVariable(name, value, op, delimiter);
        if (var == null) {
            var = new StorableEnvVar(name, value, op, delimiter);
            this.addVariable(var);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return var;
    }

    public IBuildEnvironmentVariable createVariable(String name) {
        return this.createVariable(name, null, 1, null);
    }

    public IBuildEnvironmentVariable createVariable(String name, String value) {
        return this.createVariable(name, value, 1, null);
    }

    public IBuildEnvironmentVariable createVariable(String name, String value, String delimiter) {
        return this.createVariable(name, value, 1, delimiter);
    }

    public IBuildEnvironmentVariable checkVariable(String name, String value, int op, String delimiter) {
        IBuildEnvironmentVariable var = this.getVariable(name);
        if (var != null && this.checkStrings(var.getValue(), value) && var.getOperation() == op && this.checkStrings(var.getDelimiter(), delimiter)) {
            return var;
        }
        return null;
    }

    private boolean checkStrings(String str1, String str2) {
        if (str1 != null && str1.equals(str2)) {
            return true;
        }
        return str1 == str2;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    public boolean isChanged() {
        return this.fIsChanged;
    }

    public void setChanged(boolean changed) {
        this.fIsChanged = changed;
    }

    public IBuildEnvironmentVariable getVariable(String name) {
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        EnvironmentVariableProvider provider = EnvironmentVariableProvider.getDefault();
        if (!provider.isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        return (IBuildEnvironmentVariable)this.getMap().get(name);
    }

    public void setVariales(IBuildEnvironmentVariable[] vars) {
        if (vars == null || vars.length == 0) {
            this.deleteAll();
        } else {
            if (this.getMap().size() != 0) {
                Iterator iter = this.getMap().values().iterator();
                while (iter.hasNext()) {
                    IBuildEnvironmentVariable v = (IBuildEnvironmentVariable)iter.next();
                    int i = 0;
                    while (i < vars.length) {
                        if (v.getName().equals(vars[i].getName())) break;
                        ++i;
                    }
                    if (i != vars.length) continue;
                    this.deleteVariable(v.getName());
                }
            }
            this.createVriables(vars);
        }
    }

    public void createVriables(IBuildEnvironmentVariable[] vars) {
        int i = 0;
        while (i < vars.length) {
            this.createVariable(vars[i].getName(), vars[i].getValue(), vars[i].getOperation(), vars[i].getDelimiter());
            ++i;
        }
    }

    public IBuildEnvironmentVariable[] getVariables() {
        Collection vars = this.getMap().values();
        return vars.toArray(new IBuildEnvironmentVariable[vars.size()]);
    }

    IBuildEnvironmentVariable deleteVariable(String name) {
        IBuildEnvironmentVariable var;
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
        if (!provider.isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        if ((var = (IBuildEnvironmentVariable)this.getMap().remove(name)) != null) {
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return var;
    }

    public boolean deleteAll() {
        Map map = this.getMap();
        if (map.size() > 0) {
            this.fIsDirty = true;
            this.fIsChanged = true;
            map.clear();
            return true;
        }
        return false;
    }
}

