/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.core.runtime.IPath;

public class CdtPathEntryMacroSupplier
implements IBuildMacroSupplier {
    private static CdtPathEntryMacroSupplier fInstance;

    private CdtPathEntryMacroSupplier() {
    }

    public static CdtPathEntryMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new CdtPathEntryMacroSupplier();
        }
        return fInstance;
    }

    public IBuildMacro getMacro(String macroName, int contextType, Object contextData) {
        if (contextType != 5) {
            return null;
        }
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        IPathEntryVariableManager mngr = CCorePlugin.getDefault().getPathEntryVariableManager();
        if (mngr == null) {
            return null;
        }
        IPath path = mngr.getValue(macroName);
        if (path != null) {
            return new BuildMacro(macroName, 7, path.toOSString());
        }
        return null;
    }

    public IBuildMacro[] getMacros(int contextType, Object contextData) {
        if (contextType != 5) {
            return null;
        }
        IPathEntryVariableManager mngr = CCorePlugin.getDefault().getPathEntryVariableManager();
        if (mngr == null) {
            return null;
        }
        String[] names = mngr.getVariableNames();
        IBuildMacro[] macros = new BuildMacro[names.length];
        int i = 0;
        while (i < names.length) {
            macros[i] = new BuildMacro(names[i], 7, mngr.getValue(names[i]).toOSString());
            ++i;
        }
        return macros;
    }
}

