/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.ExceptionHandler;
import edu.uoregon.tau.vis.VisRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import javax.media.opengl.GL;

public class VisTools {
    private static ExceptionHandler exceptionHandler;
    public static final double fontHeight = 139.0;
    public static final double fontAscent = 105.0;
    public static final double fontDescent = 34.0;

    public static void glSetColor(GL gL, Color color) {
        gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public static void glApplyInvertableColor(VisRenderer visRenderer, Color color) {
        if (visRenderer.getReverseVideo()) {
            VisTools.glSetColor(visRenderer.getGLAutoDrawable().getGL(), VisTools.invert(color));
        } else {
            VisTools.glSetColor(visRenderer.getGLAutoDrawable().getGL(), color);
        }
    }

    public static Color invert(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static void verr(String string) {
        if (System.getProperty("vis.verbose") != null) {
            System.err.println(string);
        }
    }

    public static void vout(String string) {
        if (System.getProperty("vis.verbose") != null) {
            System.out.println(string);
        }
    }

    public static void vout(Object object, String string) {
        if (System.getProperty("vis.verbose") != null) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.out.println(string2 + ": " + string);
        }
    }

    public static void verr(Object object, String string) {
        if (System.getProperty("vis.verbose") != null) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.println(string2 + ": " + string);
        }
    }

    static void addCompItem(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        container.add(component, gridBagConstraints);
    }

    public static boolean isSufficientlyEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static boolean isSufficientlyEqual(double d, double d2) {
        return VisTools.isSufficientlyEqual(d, d2, 0.01);
    }

    public static void setSwingExceptionHandler(ExceptionHandler exceptionHandler) {
        VisTools.exceptionHandler = exceptionHandler;
    }

    public static void handleException(Exception exception) {
        if (exceptionHandler == null) {
            throw new RuntimeException(exception);
        }
        exceptionHandler.handleException(exception);
    }
}

