/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.XMLWriter;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesViewContentHandler;

public class RepositoryRoot
extends PlatformObject {
    public static final String[] DEFAULT_AUTO_REFRESH_FILES = new String[]{".project"};
    private static final String DEFINED_MODULE_PREFIX = "module:";
    ICVSRepositoryLocation root;
    String name;
    Map versionAndBranchTags = new HashMap();
    Map autoRefreshFiles = new HashMap();
    Map modulesCache;
    Object modulesCacheLock = new Object();
    List dateTags = new ArrayList();
    static /* synthetic */ Class class$0;

    public RepositoryRoot(ICVSRepositoryLocation root) {
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public ICVSRemoteFolder getRemoteFolder(String path, CVSTag tag, IProgressMonitor monitor) {
        if (RepositoryRoot.isDefinedModuleName(path)) {
            return this.getDefinedModule(RepositoryRoot.getDefinedModuleName(path), tag, monitor);
        }
        return this.root.getRemoteFolder(path, tag);
    }

    static boolean isDefinedModuleName(String path) {
        return path.startsWith(DEFINED_MODULE_PREFIX);
    }

    static String getDefinedModuleName(String path) {
        return path.substring(DEFINED_MODULE_PREFIX.length());
    }

    static String asDefinedModulePath(String path) {
        return DEFINED_MODULE_PREFIX + path;
    }

    private ICVSRemoteFolder getDefinedModule(String path, CVSTag tag, IProgressMonitor monitor) {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        ICVSRemoteFolder folder = (ICVSRemoteFolder)cache.get(path);
        if (folder != null) {
            folder = (ICVSRemoteFolder)folder.forTag(tag);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDefinedModulesCache(CVSTag tag, IProgressMonitor monitor) {
        if (this.modulesCache == null) {
            try {
                ICVSRemoteResource[] folders = this.root.members(CVSTag.DEFAULT, true, monitor);
                Object object = this.modulesCacheLock;
                synchronized (object) {
                    this.modulesCache = new HashMap();
                    int i = 0;
                    while (i < folders.length) {
                        ICVSRemoteResource resource = folders[i];
                        this.modulesCache.put(resource.getName(), resource);
                        ++i;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
                return new HashMap();
            }
        }
        return this.modulesCache;
    }

    public ICVSRemoteResource[] getDefinedModules(CVSTag tag, IProgressMonitor monitor) {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        return cache.values().toArray(new ICVSRemoteResource[cache.size()]);
    }

    public static String getRemotePathFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSRemoteFolder remoteFolder;
            if (resource instanceof ICVSRemoteFolder && (remoteFolder = (ICVSRemoteFolder)resource).isDefinedModule()) {
                return RepositoryRoot.asDefinedModulePath(remoteFolder.getName());
            }
            FolderSyncInfo info = ((ICVSFolder)resource).getFolderSyncInfo();
            if (info == null) {
                throw new CVSException(NLS.bind((String)CVSUIMessages.RepositoryRoot_folderInfoMissing, (Object[])new String[]{resource.getName()}));
            }
            return info.getRepository();
        }
        FolderSyncInfo info = resource.getParent().getFolderSyncInfo();
        if (info == null) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.RepositoryRoot_folderInfoMissing, (Object[])new String[]{resource.getParent().getName()}));
        }
        String path = new Path(null, info.getRepository()).append(resource.getName()).toString();
        return path;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addTags(String remotePath, CVSTag[] tags) {
        this.addDateTags(tags);
        this.addVersionAndBranchTags(remotePath, tags);
    }

    private void addDateTags(CVSTag[] tags) {
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getType() == 3) {
                this.dateTags.add(tags[i]);
            }
            ++i;
        }
    }

    private void addVersionAndBranchTags(String remotePath, CVSTag[] tags) {
        String name = this.getCachePathFor(remotePath);
        TagCacheEntry entry = (TagCacheEntry)this.versionAndBranchTags.get(name);
        if (entry == null) {
            entry = new TagCacheEntry();
            this.versionAndBranchTags.put(name, entry);
        } else {
            entry.accessed();
        }
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getType() != 3) {
                entry.tags.add(tags[i]);
            }
            ++i;
        }
    }

    public void addDateTag(CVSTag tag) {
        if (!this.dateTags.contains(tag)) {
            this.dateTags.add(tag);
        }
    }

    public void removeDateTag(CVSTag tag) {
        if (this.dateTags.contains(tag)) {
            this.dateTags.remove(tag);
        }
    }

    public CVSTag[] getDateTags() {
        return this.dateTags.toArray(new CVSTag[this.dateTags.size()]);
    }

    public void removeTags(String remotePath, CVSTag[] tags) {
        this.removeDateTags(tags);
        this.removeVersionAndBranchTags(remotePath, tags);
    }

    private void removeDateTags(CVSTag[] tags) {
        if (this.dateTags.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < tags.length) {
            this.dateTags.remove(tags[i]);
            ++i;
        }
    }

    private void removeVersionAndBranchTags(String remotePath, CVSTag[] tags) {
        String name = this.getCachePathFor(remotePath);
        TagCacheEntry entry = (TagCacheEntry)this.versionAndBranchTags.get(name);
        if (entry == null) {
            return;
        }
        int i = 0;
        while (i < tags.length) {
            entry.tags.remove(tags[i]);
            ++i;
        }
        entry.accessed();
    }

    public String[] getAutoRefreshFiles(String remotePath) {
        String name = this.getCachePathFor(remotePath);
        Set files = (Set)this.autoRefreshFiles.get(name);
        if (files == null || files.isEmpty()) {
            if (RepositoryRoot.isDefinedModuleName(remotePath)) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < DEFAULT_AUTO_REFRESH_FILES.length) {
                String relativePath = DEFAULT_AUTO_REFRESH_FILES[i];
                result.add(new Path(null, remotePath).append(relativePath).toString());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public void setAutoRefreshFiles(String remotePath, String[] autoRefreshFiles) {
        HashSet<String> newFiles = new HashSet<String>(Arrays.asList(autoRefreshFiles));
        if (autoRefreshFiles.length == DEFAULT_AUTO_REFRESH_FILES.length) {
            boolean isDefault = true;
            int i = 0;
            while (i < DEFAULT_AUTO_REFRESH_FILES.length) {
                String filePath = DEFAULT_AUTO_REFRESH_FILES[i];
                if (!newFiles.contains(new Path(null, remotePath).append(filePath).toString())) {
                    isDefault = false;
                    break;
                }
                ++i;
            }
            if (isDefault) {
                this.autoRefreshFiles.remove(this.getCachePathFor(remotePath));
                return;
            }
        }
        this.autoRefreshFiles.put(this.getCachePathFor(remotePath), newFiles);
    }

    public CVSTag[] refreshDefinedTags(ICVSFolder folder, boolean recurse, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100);
        CVSTag[] tags = null;
        if (!recurse && !folder.getFolderSyncInfo().isVirtualDirectory()) {
            tags = this.fetchTagsUsingAutoRefreshFiles(folder, Policy.subMonitorFor(monitor, 50));
        }
        if (tags == null || tags.length == 0) {
            tags = this.fetchTagsUsingLog(folder, recurse, Policy.subMonitorFor(monitor, 50));
        }
        if (tags != null && tags.length > 0) {
            String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)folder);
            this.addTags(remotePath, tags);
        }
        monitor.done();
        return tags;
    }

    private CVSTag[] fetchTagsUsingLog(ICVSFolder folder, final boolean recurse, IProgressMonitor monitor) throws CVSException {
        RemoteLogOperation.LogEntryCache logEntries = new RemoteLogOperation.LogEntryCache();
        RemoteLogOperation operation = new RemoteLogOperation(null, new ICVSRemoteResource[]{this.asRemoteResource(folder)}, null, null, logEntries){

            protected Command.LocalOption[] getLocalOptions(CVSTag tag1, CVSTag tag2) {
                Command.LocalOption[] options = new Command.LocalOption[]{};
                if (recurse) {
                    return options;
                }
                Command.LocalOption[] newOptions = new Command.LocalOption[options.length + 1];
                System.arraycopy(options, 0, newOptions, 0, options.length);
                newOptions[options.length] = Command.DO_NOT_RECURSE;
                return newOptions;
            }
        };
        try {
            operation.run(monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
        String[] keys = logEntries.getCachedFilePaths();
        HashSet<CVSTag> tags = new HashSet<CVSTag>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            ILogEntry[] entries = logEntries.getLogEntries(key);
            int j = 0;
            while (j < entries.length) {
                ILogEntry entry = entries[j];
                tags.addAll(Arrays.asList(entry.getTags()));
                ++j;
            }
            ++i;
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    private ICVSRemoteResource asRemoteResource(ICVSFolder folder) throws CVSException {
        if (folder instanceof ICVSRemoteResource) {
            return (ICVSRemoteResource)folder;
        }
        return CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)folder);
    }

    private CVSTag[] fetchTagsUsingAutoRefreshFiles(ICVSFolder folder, IProgressMonitor monitor) throws TeamException {
        CVSTag[] cVSTagArray;
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)folder);
        String[] filesToRefresh = this.getAutoRefreshFiles(remotePath);
        try {
            monitor.beginTask(null, filesToRefresh.length * 10);
            ArrayList<CVSTag> tags = new ArrayList<CVSTag>();
            int i = 0;
            while (i < filesToRefresh.length) {
                block6: {
                    ICVSRemoteFile file = this.root.getRemoteFile(filesToRefresh[i], CVSTag.DEFAULT);
                    try {
                        tags.addAll(Arrays.asList(this.fetchTags(file, Policy.subMonitorFor(monitor, 5))));
                    }
                    catch (TeamException e) {
                        IStatus[] children;
                        IStatus status = e.getStatus();
                        boolean doesNotExist = false;
                        if (status.getCode() == -10 && status.isMultiStatus() && (children = status.getChildren()).length == 1 && children[0].getCode() == -17) {
                            doesNotExist = true;
                        }
                        if (doesNotExist) break block6;
                        throw e;
                    }
                }
                ++i;
            }
            cVSTagArray = tags.toArray(new CVSTag[tags.size()]);
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return cVSTagArray;
    }

    private CVSTag[] fetchTags(ICVSRemoteFile file, IProgressMonitor monitor) throws TeamException {
        HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
        ILogEntry[] entries = file.getLogEntries(monitor);
        int j = 0;
        while (j < entries.length) {
            CVSTag[] tags = entries[j].getTags();
            int k = 0;
            while (k < tags.length) {
                tagSet.add(tags[k]);
                ++k;
            }
            ++j;
        }
        return tagSet.toArray(new CVSTag[0]);
    }

    private String getCachePathFor(String remotePath) {
        return remotePath;
    }

    public void writeState(XMLWriter writer) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.clear();
        attributes.put("id", this.root.getLocation(false));
        if (this.name != null) {
            attributes.put("name", this.name);
        }
        writer.startTag("repository", attributes, true);
        if (!this.dateTags.isEmpty()) {
            writer.startTag("date-tags", attributes, true);
            Iterator iter = this.dateTags.iterator();
            while (iter.hasNext()) {
                CVSTag tag = (CVSTag)iter.next();
                this.writeATag(writer, attributes, tag, "date-tag");
            }
            writer.endTag("date-tags");
        }
        String[] paths = this.getKnownRemotePaths();
        int i = 0;
        while (i < paths.length) {
            Set refreshSet;
            boolean writeOutTags;
            String path = paths[i];
            attributes.clear();
            String name = path;
            if (RepositoryRoot.isDefinedModuleName(path)) {
                name = RepositoryRoot.getDefinedModuleName(path);
                attributes.put("type", "defined");
            }
            attributes.put("path", name);
            TagCacheEntry entry = (TagCacheEntry)this.versionAndBranchTags.get(path);
            boolean bl = writeOutTags = entry != null && !entry.isExpired();
            if (writeOutTags) {
                attributes.put("lastAcessTime", Long.toString(entry.lastAccessTime));
            }
            writer.startTag("module", attributes, true);
            if (writeOutTags) {
                Iterator tagIt = entry.tags.iterator();
                while (tagIt.hasNext()) {
                    CVSTag tag = (CVSTag)tagIt.next();
                    this.writeATag(writer, attributes, tag, "tag");
                }
            }
            if ((refreshSet = (Set)this.autoRefreshFiles.get(path)) != null) {
                Iterator filenameIt = refreshSet.iterator();
                while (filenameIt.hasNext()) {
                    String filename = (String)filenameIt.next();
                    attributes.clear();
                    attributes.put("full-path", filename);
                    writer.startAndEndTag("auto-refresh-file", attributes, true);
                }
            }
            writer.endTag("module");
            ++i;
        }
        writer.endTag("repository");
    }

    private void writeATag(XMLWriter writer, HashMap attributes, CVSTag tag, String s) {
        attributes.clear();
        attributes.put("name", tag.getName());
        attributes.put("type", RepositoriesViewContentHandler.TAG_TYPES[tag.getType()]);
        writer.startAndEndTag(s, attributes, true);
    }

    public CVSTag[] getAllKnownTags(String remotePath) {
        TagCacheEntry entry = (TagCacheEntry)this.versionAndBranchTags.get(this.getCachePathFor(remotePath));
        if (entry != null) {
            entry.accessed();
            CVSTag[] tags1 = entry.tags.toArray(new CVSTag[entry.tags.size()]);
            CVSTag[] tags2 = this.getDateTags();
            int len = tags1.length + tags2.length;
            CVSTag[] tags = new CVSTag[len];
            int i = 0;
            while (i < len) {
                tags[i] = i < tags1.length ? tags1[i] : tags2[i - tags1.length];
                ++i;
            }
            return tags;
        }
        return this.getDateTags();
    }

    public String[] getKnownRemotePaths() {
        HashSet paths = new HashSet();
        paths.addAll(this.versionAndBranchTags.keySet());
        paths.addAll(this.autoRefreshFiles.keySet());
        return paths.toArray(new String[paths.size()]);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getRoot();
        }
        return super.getAdapter(adapter);
    }

    public boolean tagIsKnown(ICVSRemoteResource remoteResource) {
        if (remoteResource instanceof ICVSRemoteFolder) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)remoteResource;
            String path = this.getCachePathFor(folder.getRepositoryRelativePath());
            CVSTag[] tags = this.getAllKnownTags(path);
            CVSTag tag = folder.getTag();
            int i = 0;
            while (i < tags.length) {
                CVSTag knownTag = tags[i];
                if (knownTag.equals((Object)tag)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Object object = this.modulesCacheLock;
        synchronized (object) {
            if (this.modulesCache != null) {
                this.modulesCache = null;
            }
        }
    }

    void setRepositoryLocation(ICVSRepositoryLocation root) {
        this.root = root;
    }

    void setLastAccessedTime(String remotePath, long lastAccessTime) {
        TagCacheEntry entry = (TagCacheEntry)this.versionAndBranchTags.get(this.getCachePathFor(remotePath));
        if (entry != null) {
            entry.lastAccessTime = lastAccessTime;
        }
    }

    public static class TagCacheEntry {
        Set tags = new HashSet();
        long lastAccessTime;
        private static final int CACHE_LIFESPAN_IN_DAYS = 7;

        public TagCacheEntry() {
            this.accessed();
        }

        public boolean isExpired() {
            long currentTime = System.currentTimeMillis();
            long ms = currentTime - this.lastAccessTime;
            int seconds = (int)ms / 1000;
            int hours = seconds / 60 / 60;
            int days = hours / 24;
            return days > 7;
        }

        public void accessed() {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }
}

