/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplates;

public class CPPClassTemplatePartialSpecialization
extends CPPClassTemplate
implements ICPPClassTemplatePartialSpecialization,
ICPPSpecialization {
    private IType[] arguments;

    public CPPClassTemplatePartialSpecialization(ICPPASTTemplateId name) {
        super(name);
    }

    public IType[] getArguments() {
        if (this.arguments == null) {
            ICPPASTTemplateId id = (ICPPASTTemplateId)this.getTemplateName();
            this.arguments = CPPTemplates.createTypeArray(id.getTemplateArguments());
        }
        return this.arguments;
    }

    public ICPPClassTemplate getPrimaryClassTemplate() {
        ICPPASTTemplateId id = (ICPPASTTemplateId)this.getTemplateName();
        return (ICPPClassTemplate)id.getTemplateName().resolveBinding();
    }

    public IBinding instantiate(IType[] args) {
        ICPPSpecialization instance = this.getInstance(args);
        if (instance != null) {
            return instance;
        }
        IType[] specArgs = this.getArguments();
        if (specArgs.length != this.arguments.length) {
            return null;
        }
        ObjectMap argMap = new ObjectMap(specArgs.length);
        int numSpecArgs = specArgs.length;
        int i = 0;
        while (i < numSpecArgs) {
            IType spec = specArgs[i];
            IType arg = args[i];
            if (CPPTemplates.typeContainsTemplateParameter(arg)) {
                return this.deferredInstance(args);
            }
            try {
                if (!CPPTemplates.deduceTemplateArgument(argMap, spec, arg)) {
                    return null;
                }
            }
            catch (DOMException dOMException) {
                return null;
            }
            ++i;
        }
        ICPPTemplateParameter[] params = this.getTemplateParameters();
        int numParams = params.length;
        int i2 = 0;
        while (i2 < numParams) {
            if (params[i2] instanceof IType && !argMap.containsKey(params[i2])) {
                return null;
            }
            ++i2;
        }
        instance = (ICPPTemplateInstance)CPPTemplates.createInstance((ICPPScope)this.getScope(), this, argMap, args);
        this.addSpecialization(args, instance);
        return instance;
    }

    public IBinding getSpecializedBinding() {
        return this.getPrimaryClassTemplate();
    }
}

