/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;

public class CPPFunctionSpecialization
extends CPPSpecialization
implements ICPPFunction,
ICPPInternalFunction {
    private IFunctionType type = null;
    private IParameter[] specializedParams = null;

    public CPPFunctionSpecialization(IBinding orig, ICPPScope scope, ObjectMap argMap) {
        super(orig, scope, argMap);
    }

    private ICPPFunction getFunction() {
        return (ICPPFunction)this.getSpecializedBinding();
    }

    public IParameter[] getParameters() throws DOMException {
        if (this.specializedParams == null) {
            ICPPFunction function = (ICPPFunction)this.getSpecializedBinding();
            IParameter[] params = function.getParameters();
            this.specializedParams = new IParameter[params.length];
            int i = 0;
            while (i < params.length) {
                this.specializedParams[i] = new CPPParameterSpecialization((ICPPParameter)params[i], (ICPPScope)this.getScope(), this.argumentMap);
                ++i;
            }
        }
        return this.specializedParams;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public IFunctionType getType() throws DOMException {
        if (this.type == null) {
            ICPPFunction function = (ICPPFunction)this.getSpecializedBinding();
            this.type = function.getType();
            this.type = (IFunctionType)CPPTemplates.instantiateType(this.type, this.argumentMap);
        }
        return this.type;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isInline() throws DOMException {
        if (this.getDefinition() != null) {
            IASTNode def = this.getDefinition();
            while (!(def instanceof IASTFunctionDefinition)) {
                def = def.getParent();
            }
            return ((IASTFunctionDefinition)def).getDeclSpecifier().isInline();
        }
        return this.getFunction().isInline();
    }

    public boolean isStatic() {
        return this.isStatic(true);
    }

    public boolean isStatic(boolean resolveAll) {
        ICPPInternalFunction f = (ICPPInternalFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isStatic(resolveAll);
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    public boolean isExtern() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isExtern();
        }
        return CPPFunction.hasStorageClass(this, 2);
    }

    public boolean isAuto() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isAuto();
        }
        return CPPFunction.hasStorageClass(this, 4);
    }

    public boolean isRegister() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isRegister();
        }
        return CPPFunction.hasStorageClass(this, 5);
    }

    public boolean takesVarArgs() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.takesVarArgs();
        }
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)this.getDefinition();
        if (dtor != null) {
            return dtor.takesVarArgs();
        }
        ICPPASTFunctionDeclarator[] ds = (ICPPASTFunctionDeclarator[])this.getDeclarations();
        if (ds != null && ds.length > 0) {
            return ds[0].takesVarArgs();
        }
        return false;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPFunction.CPPFunctionDelegate(name, this);
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTDeclarator dtor = param.getDeclarator();
        while (dtor.getNestedDeclarator() != null) {
            dtor = dtor.getNestedDeclarator();
        }
        IASTName name = dtor.getName();
        IBinding binding = name.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        try {
            IParameter[] params = this.getParameters();
            if (i < params.length) {
                name.setBinding(params[i]);
                if (params[i] instanceof ICPPInternalBinding) {
                    ((ICPPInternalBinding)((Object)params[i])).addDeclaration(name);
                }
                return params[i];
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }

    public void addDefinition(IASTNode node) {
        IASTNode n = node;
        while (n instanceof IASTName) {
            n = n.getParent();
        }
        if (!(n instanceof ICPPASTFunctionDeclarator)) {
            return;
        }
        this.updateParameterBindings((ICPPASTFunctionDeclarator)n);
        super.addDefinition(node);
    }

    public void addDeclaration(IASTNode node) {
        IASTNode n = node;
        while (n instanceof IASTName) {
            n = n.getParent();
        }
        if (!(n instanceof ICPPASTFunctionDeclarator)) {
            return;
        }
        this.updateParameterBindings((ICPPASTFunctionDeclarator)n);
        super.addDeclaration(node);
    }

    protected void updateParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        IParameter[] params = null;
        try {
            params = this.getParameters();
        }
        catch (DOMException dOMException) {
            return;
        }
        IASTParameterDeclaration[] nps = fdtor.getParameters();
        int i = 0;
        while (i < nps.length) {
            if (params[i] != null) {
                IASTDeclarator dtor = nps[i].getDeclarator();
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                IASTName name = dtor.getName();
                name.setBinding(params[i]);
                if (params[i] instanceof ICPPInternalBinding) {
                    ((ICPPInternalBinding)((Object)params[i])).addDeclaration(name);
                }
            }
            ++i;
        }
    }
}

