/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class ContentTypeProcessor
extends CModelOperation {
    CModelManager fManager;
    CElementDelta fCurrentDelta;
    IContentTypeManager.ContentTypeChangeEvent[] fEvents;

    public ContentTypeProcessor(IContentTypeManager.ContentTypeChangeEvent[] events) {
        super(CModelManager.getDefault().getCModel());
        this.fEvents = events;
        this.fManager = CModelManager.getDefault();
        CModel root = this.fManager.getCModel();
        this.fCurrentDelta = new CElementDelta(root);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected void executeOperation() throws CModelException {
        int i = 0;
        while (i < this.fEvents.length) {
            IContentType contentType = this.fEvents[i].getContentType();
            IScopeContext context = this.fEvents[i].getContext();
            ICProject[] cprojects = this.getAffectedProjects(this.fEvents[i]);
            int k = 0;
            while (k < cprojects.length) {
                this.processContentType(cprojects[k], contentType, context);
                ++k;
            }
            ++i;
        }
        if (this.fCurrentDelta.getAffectedChildren().length > 0) {
            this.addDelta(this.fCurrentDelta);
        }
    }

    public static void processContentTypeChanges(IContentTypeManager.ContentTypeChangeEvent[] events) {
        try {
            ContentTypeProcessor op = new ContentTypeProcessor(events);
            op.runOperation(null);
        }
        catch (CModelException cModelException) {}
    }

    private boolean isRegisteredContentTypeId(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] ids = CoreModel.getRegistedContentTypeIds();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void processContentType(ICElement celement, IContentType contentType, IScopeContext context) {
        if (celement instanceof IOpenable) {
            int type = celement.getElementType();
            switch (type) {
                case 11: {
                    CElementInfo info = (CElementInfo)this.fManager.peekAtInfo(celement);
                    if (info == null) break;
                    ICElement[] celements = info.getChildren();
                    int i = 0;
                    while (i < celements.length) {
                        this.processContentType(celements[i], contentType, context);
                        ++i;
                    }
                    break;
                }
                case 12: {
                    CElementInfo info = (CElementInfo)this.fManager.peekAtInfo(celement);
                    if (info == null) break;
                    try {
                        int i;
                        ICElement[] celements = info.getChildren();
                        IResource resource = celement.getResource();
                        IResource[] members = null;
                        if (resource instanceof IContainer) {
                            members = ((IContainer)resource).members();
                        }
                        if (members != null) {
                            i = 0;
                            while (i < members.length) {
                                if (members[i] instanceof IFile) {
                                    IFile file = (IFile)members[i];
                                    String name = file.getName();
                                    IContentType cType = CCorePlugin.getContentType(file.getProject(), name);
                                    if (cType != null && cType.equals(contentType)) {
                                        ICElement newElement;
                                        boolean found = false;
                                        int j = 0;
                                        while (j < celements.length) {
                                            if (celements[j].getElementName().equals(name)) {
                                                if (celements[j].getElementType() == 60) {
                                                    ITranslationUnit unit = (ITranslationUnit)celements[j];
                                                    if (!cType.getId().equals(unit.getContentTypeId()) && this.isRegisteredContentTypeId(cType.getId())) {
                                                        this.elementChanged(celements[j]);
                                                    }
                                                }
                                                found = true;
                                                break;
                                            }
                                            ++j;
                                        }
                                        if (!found && (newElement = CoreModel.getDefault().create(file)) != null) {
                                            this.elementAdded(newElement, celement);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        i = 0;
                        while (i < celements.length) {
                            this.processContentType(celements[i], contentType, context);
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 60: {
                    String oldId = ((ITranslationUnit)celement).getContentTypeId();
                    if (!contentType.getId().equals(oldId)) break;
                    try {
                        String newId;
                        IContentType cType = CCorePlugin.getContentType(celement.getCProject().getProject(), celement.getElementName());
                        String string = newId = cType != null ? cType.getId() : "";
                        if (this.isRegisteredContentTypeId(newId)) {
                            if (oldId.equals(newId)) break;
                            this.elementChanged(celement);
                            break;
                        }
                        this.elementRemoved(celement, celement.getParent());
                        break;
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
    }

    private void nonCResourcesChanged(ICElement parent) {
        if (parent instanceof Openable && ((Openable)parent).isOpen()) {
            try {
                CElementInfo info = ((Openable)parent).getElementInfo();
                switch (parent.getElementType()) {
                    case 10: {
                        ((CModelInfo)info).setNonCResources(null);
                        break;
                    }
                    case 11: {
                        ((CProjectInfo)info).setNonCResources(null);
                        break;
                    }
                    case 12: {
                        ICProject cproject;
                        CProjectInfo pinfo;
                        ((CContainerInfo)info).setNonCResources(null);
                        if (!(parent instanceof ISourceRoot) || !(parent.getResource() instanceof IProject) || (pinfo = (CProjectInfo)this.fManager.peekAtInfo(cproject = parent.getCProject())) == null) break;
                        pinfo.setNonCResources(null);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    private void elementAdded(ICElement celement, ICElement parent) throws CModelException {
        if (celement instanceof Openable) {
            this.addToParentInfo((Openable)celement);
        }
        this.fCurrentDelta.added(celement);
        this.nonCResourcesChanged(parent);
    }

    private void addToParentInfo(Openable child) throws CModelException {
        CElementInfo info;
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen() && !(info = parent.getElementInfo()).includesChild(child)) {
            info.addChild(child);
        }
    }

    private void elementRemoved(ICElement celement, ICElement parent) throws CModelException {
        this.fCurrentDelta.removed(celement);
        this.nonCResourcesChanged(parent);
        this.removeFromParentInfo(celement);
        this.fManager.releaseCElement(celement);
    }

    private void elementChanged(ICElement element) throws CModelException {
        if (element instanceof IOpenable) {
            ((IOpenable)((Object)element)).close();
        }
        this.fCurrentDelta.changed(element, 0x1000001);
    }

    private void removeFromParentInfo(ICElement child) throws CModelException {
        ICElement parent = child.getParent();
        if (parent != null && parent instanceof Parent && this.fManager.peekAtInfo(parent) != null) {
            ((Parent)parent).removeChild(child);
        }
    }

    private ICProject[] getAffectedProjects(IContentTypeManager.ContentTypeChangeEvent event) {
        try {
            ICModel cmodel = CoreModel.getDefault().getCModel();
            ICProject[] cprojects = cmodel.getCProjects();
            IScopeContext context = event.getContext();
            if (context != null && "project".equals(context.getName())) {
                IPath location = context.getLocation();
                int i = 0;
                while (i < cprojects.length) {
                    if (cprojects[i].getProject().getLocation().isPrefixOf(location)) {
                        return new ICProject[]{cprojects[i]};
                    }
                    ++i;
                }
                return new ICProject[0];
            }
            ArrayList<ICProject> list = new ArrayList<ICProject>(cprojects.length);
            int i = 0;
            while (i < cprojects.length) {
                list.add(cprojects[i]);
                ++i;
            }
            return list.toArray(new ICProject[list.size()]);
        }
        catch (CModelException cModelException) {
            return new ICProject[0];
        }
    }
}

