/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTEnumerationSpecifier
extends ASTSymbol
implements IASTEnumerationSpecifier {
    private final ASTQualifiedNamedElement qualifiedName;
    private final char[] fn;
    private List enumerators = Collections.EMPTY_LIST;
    private static final int ENUMERATOR_LIST_SIZE = 4;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTEnumerationSpecifier(ISymbol symbol, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, char[] filename) {
        super(symbol);
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
        this.fn = filename;
    }

    public void addEnumerator(IASTEnumerator enumerator) {
        if (this.enumerators == Collections.EMPTY_LIST) {
            this.enumerators = new ArrayList(4);
        }
        this.enumerators.add(enumerator);
    }

    public Iterator getEnumerators() {
        return this.enumerators.iterator();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptEnumerationSpecifier(this);
        }
        catch (Exception exception) {}
        if (this.enumerators.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.enumerators.size()) {
            IASTEnumerator enumerator = (IASTEnumerator)this.enumerators.get(i);
            if (enumerator.getInitialValue() != null) {
                enumerator.getInitialValue().acceptElement(requestor);
            }
            ++i;
        }
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public void freeReferences() {
        if (this.enumerators.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.enumerators.size()) {
            ((IASTEnumerator)this.enumerators.get(i)).freeReferences();
            ++i;
        }
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }
}

