/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.core.runtime.CoreException;

public class PDOMInclude {
    private final PDOM pdom;
    private final int record;
    private final int INCLUDES = 0;
    private final int INCLUDED_BY = 4;
    private final int INCLUDES_NEXT = 8;
    private final int INCLUDED_BY_NEXT = 12;
    private final int INCLUDED_BY_PREV = 16;
    private final int RECORD_SIZE = 20;

    public PDOMInclude(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMInclude(PDOM pdom) throws CoreException {
        this.pdom = pdom;
        this.record = pdom.getDB().malloc(20);
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        PDOMInclude prevInclude = this.getPrevInIncludedBy();
        PDOMInclude nextInclude = this.getNextInIncludedBy();
        if (prevInclude != null) {
            prevInclude.setNextInIncludedBy(nextInclude);
        } else {
            this.getIncludes().setFirstIncludedBy(null);
        }
        if (nextInclude != null) {
            nextInclude.setPrevInIncludedBy(prevInclude);
        }
        this.pdom.getDB().free(this.record);
    }

    public PDOMFile getIncludes() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 0);
        return rec != 0 ? new PDOMFile(this.pdom, rec) : null;
    }

    public void setIncludes(PDOMFile includes) throws CoreException {
        int rec = includes != null ? includes.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 0, rec);
    }

    public PDOMFile getIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 4);
        return rec != 0 ? new PDOMFile(this.pdom, rec) : null;
    }

    public void setIncludedBy(PDOMFile includedBy) throws CoreException {
        int rec = includedBy != null ? includedBy.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 4, rec);
    }

    public PDOMInclude getNextInIncludes() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 8);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public void setNextInIncludes(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 8, rec);
    }

    public PDOMInclude getNextInIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public void setNextInIncludedBy(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public PDOMInclude getPrevInIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 16);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public void setPrevInIncludedBy(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 16, rec);
    }
}

