/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class PDOMCStructure
extends PDOMMemberOwner
implements ICompositeType {
    public PDOMCStructure(PDOM pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name);
    }

    public PDOMCStructure(PDOM pdom, int record) {
        super(pdom, record);
    }

    public int getNodeType() {
        return 5;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public int getKey() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IField[] getFields() throws DOMException {
        try {
            GetFields fields = new GetFields();
            this.accept(fields);
            return fields.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IField[0];
        }
    }

    public IField findField(String name) throws DOMException {
        FindField field = new FindField(name);
        try {
            this.accept(field);
            return null;
        }
        catch (CoreException e) {
            if (e.getStatus().equals(Status.OK_STATUS)) {
                return field.getField();
            }
            CCorePlugin.log(e);
            return null;
        }
    }

    public IScope getCompositeScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isSameType(IType type) {
        return this.equals(type);
    }

    public static class FindField
    implements IPDOMVisitor {
        private IField field;
        private final String name;

        public FindField(String name) {
            this.name = name;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            IField tField;
            if (node instanceof IField && this.name.equals((tField = (IField)((Object)node)).getName())) {
                this.field = tField;
                throw new CoreException(Status.OK_STATUS);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField getField() {
            return this.field;
        }
    }

    private static class GetFields
    implements IPDOMVisitor {
        private List fields = new ArrayList();

        private GetFields() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IField) {
                this.fields.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField[] getFields() {
            return this.fields.toArray(new IField[this.fields.size()]);
        }
    }
}

