/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

public class TypeInfoUtil {
    public static TypeInfo searchTypeInfo(IJavaProject javaProject, SimpleName accessNode, String qualifiedTypeName) throws JavaModelException {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(javaProject);
        int typeKinds = 126;
        if (accessNode != null) {
            typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)accessNode, is50OrHigher);
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        String typeName = Signature.getSimpleName((String)qualifiedTypeName);
        ArrayList typeInfos = new ArrayList();
        TypeInfoRequestor requestor = new TypeInfoRequestor(typeInfos);
        new SearchEngine().searchAllTypeNames(null, typeName.toCharArray(), 8, TypeInfoUtil.getSearchForConstant(typeKinds), searchScope, (TypeNameRequestor)requestor, 3, (IProgressMonitor)new NullProgressMonitor());
        Iterator iter = typeInfos.iterator();
        while (iter.hasNext()) {
            TypeInfo info = (TypeInfo)iter.next();
            if (!info.getFullyQualifiedName().equals(qualifiedTypeName)) continue;
            return info;
        }
        return null;
    }

    private static int getSearchForConstant(int typeKinds) {
        switch (typeKinds & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }
}

