/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CFormatter;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class CContext
extends TranslationUnitContext {
    private static final String PLATFORM_LINE_DELIMITER = System.getProperty("line.separator");

    public CContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ITranslationUnit translationUnit) {
        super(type, document, completionOffset, completionLength, translationUnit);
    }

    public int getStart() {
        try {
            IDocument document = this.getDocument();
            if (this.getCompletionLength() == 0) {
                int start = this.getCompletionOffset();
                while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                    --start;
                }
                if (start != 0 && Character.isUnicodeIdentifierStart(document.getChar(start - 1))) {
                    --start;
                }
                return start;
            }
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public boolean canEvaluate(Template template) {
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template.getPattern());
        this.getContextType().resolve(buffer, (TemplateContext)this);
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter == null) {
            lineDelimiter = PLATFORM_LINE_DELIMITER;
        }
        IPreferenceStore prefs = CUIPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.eclipse.cdt.ui.text.templates.format");
        CFormatter formatter = new CFormatter(lineDelimiter, this.getIndentation(), useCodeFormatter);
        formatter.edit(buffer, this, this.getIndentation());
        return buffer;
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            return Strings.computeIndent(lineContent, CodeFormatterUtil.getTabWidth());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }
}

