/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.editor.CAnnotationIterator;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class AbstractAnnotationHover
extends AbstractCEditorTextHover {
    private IPreferenceStore fStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
    private DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private boolean fAllAnnotations;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.getEditor() == null) {
            return null;
        }
        CDocumentProvider provider = CUIPlugin.getDefault().getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel(this.getEditor().getEditorInput());
        if (model != null) {
            CAnnotationIterator e = new CAnnotationIterator(model, true, this.fAllAnnotations);
            int layer = -1;
            String message = null;
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                AnnotationPreference preference = this.getAnnotationPreference(a);
                if (preference == null || (preference.getTextPreferenceKey() == null || !this.fStore.getBoolean(preference.getTextPreferenceKey())) && (preference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(preference.getHighlightPreferenceKey()))) continue;
                Position p = model.getPosition(a);
                int l = this.fAnnotationAccess.getLayer(a);
                if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                message = msg;
                layer = l;
            }
            if (layer > -1) {
                return this.formatMessage(message);
            }
        }
        return null;
    }

    public void setEditor(IEditorPart editor) {
        if (editor instanceof CEditor) {
            super.setEditor(editor);
        } else {
            super.setEditor(null);
        }
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

